"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDetailPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _error_callout = require("./error_callout");
var _use_step_details_breadcrumbs = require("./hooks/use_step_details_breadcrumbs");
var _waterfall_chart_container = require("./step_waterfall_chart/waterfall/waterfall_chart_container");
var _network_timings_donut = require("./step_timing_breakdown/network_timings_donut");
var _use_journey_steps = require("../monitor_details/hooks/use_journey_steps");
var _actions = require("../../state/network_events/actions");
var _object_weight_list = require("./step_objects/object_weight_list");
var _step_metrics = require("./step_metrics/step_metrics");
var _object_count_list = require("./step_objects/object_count_list");
var _monitor_details_portal = require("../monitor_add_edit/monitor_details_portal");
var _step_image = require("./step_screenshot/step_image");
var _breakdown_legend = require("./step_timing_breakdown/breakdown_legend");
var _network_timings_breakdown = require("./network_timings_breakdown");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_detail_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StepDetailPage = () => {
  var _data$details, _data$details$journey, _data$details2, _data$details3, _data$details4;
  const {
    checkGroupId,
    stepIndex
  } = (0, _reactRouterDom.useParams)();
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'stepDetail'
  });
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'stepDetail',
    delay: 15000
  });
  const {
    data,
    isFailedStep,
    currentStep
  } = (0, _use_journey_steps.useJourneySteps)();
  (0, _use_step_details_breadcrumbs.useStepDetailsBreadcrumbs)();
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch(_actions.getNetworkEvents.get({
      checkGroup: checkGroupId,
      stepIndex: Number(stepIndex)
    }));
  }, [dispatch, stepIndex, checkGroupId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallOut, {
    step: currentStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), (data === null || data === void 0 ? void 0 : (_data$details = data.details) === null || _data$details === void 0 ? void 0 : (_data$details$journey = _data$details.journey) === null || _data$details$journey === void 0 ? void 0 : _data$details$journey.config_id) && /*#__PURE__*/_react.default.createElement(_monitor_details_portal.MonitorDetailsLinkPortal, {
    configId: data.details.journey.config_id,
    name: data.details.journey.monitor.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, (data === null || data === void 0 ? void 0 : (_data$details2 = data.details) === null || _data$details2 === void 0 ? void 0 : _data$details2.journey) && currentStep && /*#__PURE__*/_react.default.createElement(_step_image.StepImage, {
    ping: data === null || data === void 0 ? void 0 : (_data$details3 = data.details) === null || _data$details3 === void 0 ? void 0 : _data$details3.journey,
    step: currentStep,
    isFailed: isFailedStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      minWidth: 150
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_network_timings_donut.NetworkTimingsDonut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      minWidth: 200
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_breakdown_legend.BreakdownLegend, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    style: {
      minWidth: 200
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_network_timings_breakdown.NetworkTimingsBreakdown, {
    monitorQueryId: data === null || data === void 0 ? void 0 : (_data$details4 = data.details) === null || _data$details4 === void 0 ? void 0 : _data$details4.journey.monitor.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_step_metrics.StepMetrics, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_object_weight_list.ObjectWeightList, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_object_count_list.ObjectCountList, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }), data && /*#__PURE__*/_react.default.createElement(_waterfall_chart_container.WaterfallChartContainer, {
    checkGroup: checkGroupId,
    stepIndex: Number(stepIndex),
    activeStep: currentStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }));
};
exports.StepDetailPage = StepDetailPage;