"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrivateLocationsAPI = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _actions = require("../../../../state/private_locations/actions");
var _selectors = require("../../../../state/private_locations/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePrivateLocationsAPI = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    loading,
    createLoading,
    deleteLoading,
    data
  } = (0, _reactRedux.useSelector)(_selectors.selectPrivateLocationsState);
  (0, _react.useEffect)(() => {
    dispatch(_actions.getPrivateLocationsAction.get());
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    if (data === null) {
      dispatch(_actions.getPrivateLocationsAction.get());
    }
  }, [data, dispatch]);
  const onCreateLocationAPI = newLoc => {
    dispatch(_actions.createPrivateLocationAction.get(newLoc));
  };
  const onEditLocationAPI = (locationId, newAttributes) => {
    dispatch(_actions.editPrivateLocationAction.get({
      locationId,
      newAttributes
    }));
  };
  const onDeleteLocationAPI = id => {
    dispatch(_actions.deletePrivateLocationAction.get(id));
  };
  return {
    onCreateLocationAPI,
    onEditLocationAPI,
    onDeleteLocationAPI,
    deleteLoading,
    loading,
    createLoading,
    privateLocations: data !== null && data !== void 0 ? data : []
  };
};
exports.usePrivateLocationsAPI = usePrivateLocationsAPI;