"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMonitorsRoute = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _refresh_button = require("../common/components/refresh_button");
var _overview_page = require("./overview/overview_page");
var _monitors_page_header = require("./management/page_header/monitors_page_header");
var _create_monitor_button = require("./create_monitor_button");
var _monitors_page = require("./monitors_page");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/route_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getMonitorsRoute = (history, location, syntheticsPath, baseTitle) => {
  const sharedProps = {
    pageTitle: /*#__PURE__*/_react.default.createElement(_monitors_page_header.MonitorsPageHeader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 16
      }
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_refresh_button.RefreshButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 22
      }
    }), /*#__PURE__*/_react.default.createElement(_create_monitor_button.CreateMonitorButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 41
      }
    })]
  };
  return [{
    title: _i18n.i18n.translate('xpack.synthetics.overviewRoute.title', {
      defaultMessage: 'Synthetics Overview | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.OVERVIEW_ROUTE,
    component: _overview_page.OverviewPage,
    dataTestSubj: 'syntheticsOverviewPage',
    pageHeader: {
      ...sharedProps,
      tabs: getMonitorsTabs(syntheticsPath, 'overview', location)
    }
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.monitorManagementRoute.title', {
      defaultMessage: 'Synthetics Management | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITORS_ROUTE,
    component: _monitors_page.MonitorManagementPage,
    dataTestSubj: 'syntheticsMonitorManagementPage',
    pageHeader: {
      ...sharedProps,
      tabs: getMonitorsTabs(syntheticsPath, 'management', location)
    }
  }];
};
exports.getMonitorsRoute = getMonitorsRoute;
const getMonitorsTabs = (syntheticsPath, selected, location) => {
  return [{
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorManagement.overviewTab.title",
      defaultMessage: "Overview",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }),
    href: `${syntheticsPath}${_constants.OVERVIEW_ROUTE}${location.search}`,
    isSelected: selected === 'overview',
    'data-test-subj': 'syntheticsMonitorOverviewTab'
  }, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorManagement.monitorsTab.title",
      defaultMessage: "Management",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }),
    href: `${syntheticsPath}${_constants.MONITORS_ROUTE}${location.search}`,
    isSelected: selected === 'management',
    'data-test-subj': 'syntheticsMonitorManagementTab'
  }];
};