"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorQueryIds = exports.OverviewAlerts = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/exploratory-view-plugin/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _synthetics_alerts = require("../../../../../../../common/constants/synthetics_alerts");
var _hooks = require("../../../../hooks");
var _overview_status = require("../../../../state/overview_status");
var _view_alerts = require("../../../common/links/view_alerts");
var _use_monitor_filters = require("../../hooks/use_monitor_filters");
var _use_monitor_query_filters = require("../../hooks/use_monitor_query_filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/overview_alerts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useMonitorQueryIds = () => {
  const {
    status
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const {
    statusFilter
  } = (0, _hooks.useGetUrlParams)();
  return (0, _react.useMemo)(() => {
    var _status$enabledMonito, _status$disabledMonit;
    let monitorIds = (_status$enabledMonito = status === null || status === void 0 ? void 0 : status.enabledMonitorQueryIds) !== null && _status$enabledMonito !== void 0 ? _status$enabledMonito : [];
    switch (statusFilter) {
      case 'up':
        monitorIds = status ? Object.entries(status.upConfigs).map(([id, config]) => config.monitorQueryId) : [];
        break;
      case 'down':
        monitorIds = status ? Object.entries(status.downConfigs).map(([id, config]) => config.monitorQueryId) : [];
        break;
      case 'disabled':
        monitorIds = (_status$disabledMonit = status === null || status === void 0 ? void 0 : status.disabledMonitorQueryIds) !== null && _status$disabledMonit !== void 0 ? _status$disabledMonit : [];
        break;
      case 'pending':
        monitorIds = status ? Object.entries(status.pendingConfigs).map(([id, config]) => config.monitorQueryId) : [];
        break;
      default:
        break;
    }
    return monitorIds.length > 0 ? monitorIds : ['false-id'];
  }, [status, statusFilter]);
};
exports.useMonitorQueryIds = useMonitorQueryIds;
const OverviewAlerts = () => {
  const {
    from,
    to
  } = (0, _hooks.useRefreshedRange)(12, 'hours');
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public2.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isAmsterdam = euiTheme.flags.hasVisColorAdjustment;
  const filters = (0, _use_monitor_filters.useMonitorFilters)({
    forAlerts: true
  });
  const {
    locations
  } = (0, _hooks.useGetUrlParams)();
  const queryFilters = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "m",
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, headingText)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: "monitorActiveAlertsCount",
    dataTestSubj: "monitorActiveAlertsCount",
    reportType: "single-metric",
    customHeight: "70px",
    dslFilters: queryFilters,
    attributes: [{
      dataType: 'alerts',
      time: {
        from,
        to
      },
      name: ALERTS_LABEL,
      selectedMetricField: _public.RECORDS_FIELD,
      reportDefinitions: {
        'kibana.alert.rule.rule_type_id': [_synthetics_alerts.SYNTHETICS_STATUS_RULE, _synthetics_alerts.SYNTHETICS_TLS_RULE],
        ...(locations !== null && locations !== void 0 && locations.length ? {
          'observer.geo.name': locations
        } : {})
      },
      filters: [{
        field: 'kibana.alert.status',
        values: ['active', 'recovered']
      }, ...filters],
      color: isAmsterdam ? euiTheme.colors.vis.euiColorVis1 : euiTheme.colors.vis.euiColorVis6
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: "monitorActiveAlertsOverTime",
    sparklineMode: true,
    customHeight: "70px",
    reportType: "kpi-over-time",
    dslFilters: queryFilters,
    attributes: [{
      seriesType: 'area',
      time: {
        from,
        to
      },
      reportDefinitions: {
        'kibana.alert.rule.rule_type_id': [_synthetics_alerts.SYNTHETICS_STATUS_RULE, _synthetics_alerts.SYNTHETICS_TLS_RULE],
        ...(locations !== null && locations !== void 0 && locations.length ? {
          'observer.geo.name': locations
        } : {})
      },
      dataType: 'alerts',
      selectedMetricField: _public.RECORDS_FIELD,
      name: ALERTS_LABEL,
      filters: [{
        field: 'kibana.alert.status',
        values: ['active', 'recovered']
      }, ...filters],
      color: isAmsterdam ? (0, _eui.euiPaletteColorBlindBehindText)()[1] : euiTheme.colors.vis.euiColorVis6
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      alignSelf: 'center'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_view_alerts.AlertsLink, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }))));
};
exports.OverviewAlerts = OverviewAlerts;
const ALERTS_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.alerts', {
  defaultMessage: 'Alerts'
});
const headingText = _i18n.i18n.translate('xpack.synthetics.overview.alerts.headingText', {
  defaultMessage: 'Last 12 hours'
});