"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorLocations = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _location_status_badges = require("../../../common/components/location_status_badges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/management/monitor_list_table/monitor_locations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorLocations = ({
  locations,
  monitorId,
  overviewStatus
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isAmsterdam = euiTheme.flags.hasVisColorAdjustment;
  const locationsToDisplay = locations.map(loc => {
    var _loc$label;
    const locById = `${monitorId}-${loc.id}`;
    let status = 'unknown';
    let color = euiTheme.colors.disabled;
    if (overviewStatus !== null && overviewStatus !== void 0 && overviewStatus.downConfigs[locById]) {
      status = 'down';
      color = isAmsterdam ? euiTheme.colors.vis.euiColorVis9 : euiTheme.colors.danger;
    } else if (overviewStatus !== null && overviewStatus !== void 0 && overviewStatus.upConfigs[locById]) {
      status = 'up';
      color = isAmsterdam ? euiTheme.colors.vis.euiColorVis0 : euiTheme.colors.success;
    }
    return {
      id: loc.id,
      label: (_loc$label = loc.label) !== null && _loc$label !== void 0 ? _loc$label : loc.id,
      status,
      color
    };
  });
  return /*#__PURE__*/_react.default.createElement(_location_status_badges.LocationStatusBadges, {
    configId: monitorId,
    locations: locationsToDisplay,
    loading: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
};
exports.MonitorLocations = MonitorLocations;