"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorEnabled = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _use_capabilities = require("../../../../../../hooks/use_capabilities");
var _hooks = require("../../../../hooks");
var _permissions = require("../../../common/components/permissions");
var labels = _interopRequireWildcard(require("./labels"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/management/monitor_list_table/monitor_enabled.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorEnabled = ({
  configId,
  monitor,
  reloadPage,
  initialLoading = false,
  isSwitchable = true
}) => {
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  const canUsePublicLocations = (0, _use_capabilities.useCanUsePublicLocations)(monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.LOCATIONS]);
  const {
    isServiceAllowed
  } = (0, _hooks.useEnablement)();
  const monitorName = monitor[_runtime_types.ConfigKey.NAME];
  const statusLabels = (0, _react.useMemo)(() => {
    return {
      failureLabel: labels.getMonitorEnabledUpdateFailureMessage(monitorName),
      enabledSuccessLabel: labels.getMonitorEnabledSuccessLabel(monitorName),
      disabledSuccessLabel: labels.getMonitorDisabledSuccessLabel(monitorName)
    };
  }, [monitorName]);
  const {
    isEnabled,
    updateMonitorEnabledState,
    status
  } = (0, _hooks.useMonitorEnableHandler)({
    configId,
    isEnabled: monitor[_runtime_types.ConfigKey.ENABLED],
    reloadPage,
    labels: statusLabels
  });
  const enabled = isEnabled !== null && isEnabled !== void 0 ? isEnabled : monitor[_runtime_types.ConfigKey.ENABLED];
  const isLoading = status === _public.FETCH_STATUS.LOADING;
  const handleEnabledChange = event => {
    const checked = event.target.checked;
    updateMonitorEnabledState(checked);
  };
  const enabledDisableLabel = enabled ? labels.DISABLE_MONITOR_LABEL : labels.ENABLE_MONITOR_LABEL;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading || initialLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    canEditSynthetics: canEditSynthetics,
    canUsePublicLocations: canUsePublicLocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(SwitchWithCursor, {
    compressed: true,
    checked: enabled,
    disabled: isLoading || !canEditSynthetics || !canUsePublicLocations || !isServiceAllowed,
    showLabel: false,
    label: enabledDisableLabel,
    title: enabledDisableLabel,
    "data-test-subj": "syntheticsIsMonitorEnabled",
    "data-is-switchable": isSwitchable,
    onChange: handleEnabledChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  })));
};

// data-* is the DOM compatible prop format
exports.MonitorEnabled = MonitorEnabled;
const SwitchWithCursor = (0, _common.euiStyled)(_eui.EuiSwitch)`
  & > button {
    cursor: ${({
  'data-is-switchable': isSwitchable
}) => isSwitchable ? undefined : 'not-allowed'};
  }
`;