"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProjectMonitorDisclaimer = exports.PROJECT_MONITOR_TITLE = exports.DeleteMonitor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _state = require("../../../../state");
var _kibana_service = require("../../../../../../utils/kibana_service");
var labels = _interopRequireWildcard(require("./labels"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/management/monitor_list_table/delete_monitor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteMonitor = ({
  name,
  reloadPage,
  configIds,
  isProjectMonitor,
  setMonitorPendingDeletion
}) => {
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const {
    spaceId
  } = (0, _hooks.useGetUrlParams)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const handleConfirmDelete = () => {
    setIsDeleting(true);
  };
  const {
    status: monitorDeleteStatus
  } = (0, _public.useFetcher)(() => {
    if (isDeleting) {
      return (0, _state.fetchDeleteMonitor)({
        configIds,
        spaceId
      });
    }
  }, [configIds, isDeleting, spaceId]);
  (0, _react.useEffect)(() => {
    const {
      coreStart,
      toasts
    } = _kibana_service.kibanaService;
    if (!isDeleting) {
      return;
    }
    if (monitorDeleteStatus === _public.FETCH_STATUS.FAILURE) {
      toasts.addDanger({
        title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "uptimeDeleteMonitorFailure",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 56,
            columnNumber: 13
          }
        }, labels.MONITOR_DELETE_FAILURE_LABEL), coreStart)
      }, {
        toastLifeTimeMs: 3000
      });
    } else if (monitorDeleteStatus === _public.FETCH_STATUS.SUCCESS) {
      reloadPage();
      toasts.addSuccess({
        title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "uptimeDeleteMonitorSuccess",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 69,
            columnNumber: 13
          }
        }, configIds.length === 1 ? _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorDeleteSuccessMessage.name', {
          defaultMessage: 'Deleted "{name}" monitor successfully.',
          values: {
            name
          }
        }) : _i18n.i18n.translate('xpack.synthetics.monitorManagement.successDeletion', {
          defaultMessage: 'Deleted {monitorCount, number} {monitorCount, plural, one {monitor} other {monitors}} successfully.',
          values: {
            monitorCount: configIds.length
          }
        })), coreStart)
      }, {
        toastLifeTimeMs: 3000
      });
    }
    if (monitorDeleteStatus === _public.FETCH_STATUS.SUCCESS || monitorDeleteStatus === _public.FETCH_STATUS.FAILURE) {
      setIsDeleting(false);
      setMonitorPendingDeletion([]);
    }
  }, [setIsDeleting, isDeleting, reloadPage, monitorDeleteStatus, setMonitorPendingDeletion, name, configIds.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: configIds.length === 1 ? _i18n.i18n.translate('xpack.synthetics.monitorManagement.deleteMonitorNameLabel', {
      defaultMessage: 'Delete "{name}" monitor?',
      values: {
        name
      }
    }) : _i18n.i18n.translate('xpack.synthetics.monitorManagement.deleteMonitorNameLabel', {
      defaultMessage: 'Delete {monitorCount, number} selected {monitorCount, plural, one {monitor} other {monitors}}?',
      values: {
        monitorCount: configIds.length
      }
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => setMonitorPendingDeletion([]),
    onConfirm: handleConfirmDelete,
    cancelButtonText: labels.NO_LABEL,
    confirmButtonText: labels.YES_LABEL,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    isLoading: isDeleting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, isProjectMonitor && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: PROJECT_MONITOR_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(ProjectMonitorDisclaimer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  })));
};
exports.DeleteMonitor = DeleteMonitor;
const PROJECT_MONITOR_TITLE = exports.PROJECT_MONITOR_TITLE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorList.disclaimer.title', {
  defaultMessage: 'Deleting project monitor will not remove it from the project source'
});
const ProjectMonitorDisclaimer = () => {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorManagement.monitorList.disclaimer.label",
    defaultMessage: "To delete it completely and stop it from being pushed again in the future, delete it from the project source. {docsLink}.",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsProjectMonitorDisclaimerLearnMoreLink",
        href: "https://elastic.co/guide/en/observability/current/synthetics-manage-monitors.html#manage-monitors-delete",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.synthetics.monitorManagement.projectDelete.docsLink', {
        defaultMessage: 'Learn more'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 5
    }
  });
};
exports.ProjectMonitorDisclaimer = ProjectMonitorDisclaimer;