"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUCCESSFUL_LABEL = exports.MonitorCompleteCount = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_monitor_query_filters = require("../hooks/use_monitor_query_filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_summary/monitor_complete_count.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorCompleteCount = props => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const {
    queryIdFilter,
    locationFilter
  } = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  if (!queryIdFilter) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: "monitorSuccessfulCount",
    align: "left",
    reportType: _public2.ReportTypes.SINGLE_METRIC,
    attributes: [{
      time: props,
      reportDefinitions: queryIdFilter,
      filters: locationFilter,
      dataType: 'synthetics',
      selectedMetricField: 'monitor_successful',
      name: SUCCESSFUL_LABEL
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  });
};
exports.MonitorCompleteCount = MonitorCompleteCount;
const SUCCESSFUL_LABEL = exports.SUCCESSFUL_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.successful', {
  defaultMessage: 'Successful'
});