"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LastTestRunComponent = exports.LastTestRun = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _test_details_link = require("../../common/links/test_details_link");
var _use_selected_location = require("../hooks/use_selected_location");
var _errors_list = require("../monitor_errors/errors_list");
var _runtime_types = require("../../../../../../common/runtime_types");
var _contexts = require("../../../contexts");
var _browser_steps_list = require("../../common/monitor_test_result/browser_steps_list");
var _single_ping_result = require("../../common/monitor_test_result/single_ping_result");
var _status_badge = require("../../common/monitor_test_result/status_badge");
var _use_journey_steps = require("../hooks/use_journey_steps");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var _use_monitor_latest_ping = require("../hooks/use_monitor_latest_ping");
var _use_date_format = require("../../../../../hooks/use_date_format");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_summary/last_test_run.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LastTestRun = () => {
  var _latestPing$monitor;
  const {
    latestPing,
    loading: pingsLoading
  } = (0, _use_monitor_latest_ping.useMonitorLatestPing)();
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    data: stepsData,
    loading: stepsLoading
  } = (0, _use_journey_steps.useJourneySteps)(latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$monitor = latestPing.monitor) === null || _latestPing$monitor === void 0 ? void 0 : _latestPing$monitor.check_group, lastRefresh);
  const loading = stepsLoading || pingsLoading;
  return /*#__PURE__*/_react.default.createElement(LastTestRunComponent, {
    stepsData: stepsData,
    latestPing: latestPing,
    loading: loading,
    stepsLoading: stepsLoading,
    isErrorDetails: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  });
};
exports.LastTestRun = LastTestRun;
const LastTestRunComponent = ({
  latestPing,
  loading,
  stepsData,
  stepsLoading,
  isErrorDetails = false
}) => {
  var _latestPing$state, _stepsData$steps;
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    css: {
      minHeight: 356
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(PanelHeader, {
    monitor: monitor,
    latestPing: latestPing,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), !(loading && !latestPing) && latestPing !== null && latestPing !== void 0 && latestPing.error ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "monitorTestRunErrorCallout",
    style: {
      marginTop: euiTheme.base,
      borderRadius: euiTheme.border.radius.medium,
      fontWeight: euiTheme.font.weight.semiBold
    },
    title: latestPing === null || latestPing === void 0 ? void 0 : latestPing.error.message,
    size: "s",
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, isErrorDetails ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "monitorTestRunViewErrorDetails",
    color: "danger",
    href: (0, _errors_list.getErrorDetailsUrl)({
      basePath,
      configId: monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.CONFIG_ID],
      locationId: selectedLocation.id,
      stateId: (_latestPing$state = latestPing.state) === null || _latestPing$state === void 0 ? void 0 : _latestPing$state.id
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.viewErrorDetails', {
    defaultMessage: 'View error details'
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }), (monitor === null || monitor === void 0 ? void 0 : monitor.type) === _runtime_types.MonitorTypeEnum.BROWSER ? /*#__PURE__*/_react.default.createElement(_browser_steps_list.BrowserStepsList, {
    steps: (_stepsData$steps = stepsData === null || stepsData === void 0 ? void 0 : stepsData.steps) !== null && _stepsData$steps !== void 0 ? _stepsData$steps : [],
    loading: stepsLoading,
    showStepNumber: true,
    showExpand: isErrorDetails,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_single_ping_result.SinglePingResult, {
    ping: latestPing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }));
};
exports.LastTestRunComponent = LastTestRunComponent;
const PanelHeader = ({
  monitor,
  latestPing,
  loading
}) => {
  var _latestPing$summary;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const formatter = (0, _use_date_format.useDateFormat)();
  const lastRunTimestamp = formatter(latestPing === null || latestPing === void 0 ? void 0 : latestPing['@timestamp']);
  const isBrowserMonitor = (monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.MONITOR_TYPE]) === _runtime_types.MonitorTypeEnum.BROWSER;
  const TitleNode = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, LAST_TEST_RUN_LABEL));
  if (loading && !latestPing) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    }, TitleNode), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      width: "52px",
      height: "20px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 11
      }
    }, isBrowserMonitor ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 44
      }
    }) : null)));
  }
  if (!latestPing) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, TitleNode);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }, TitleNode), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      flexBasis: 'fit-content'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
    status: (0, _status_badge.parseBadgeStatus)((latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$summary = latestPing.summary) === null || _latestPing$summary === void 0 ? void 0 : _latestPing$summary.down) > 0 ? 'fail' : 'success'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: {
      whiteSpace: 'nowrap'
    },
    size: "xs",
    color: euiTheme.colors.darkShade,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }, lastRunTimestamp)), isBrowserMonitor ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      marginLeft: 'auto'
    },
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "monitorSummaryViewLastTestRun",
    size: "xs",
    iconType: "inspect",
    iconSide: "left",
    href: (0, _test_details_link.getTestRunDetailLink)({
      basePath,
      monitorId,
      checkGroup: latestPing === null || latestPing === void 0 ? void 0 : latestPing.monitor.check_group,
      locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.viewTestRun', {
    defaultMessage: 'View test run'
  }))) : null));
};
const LAST_TEST_RUN_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.lastTestRunTitle', {
  defaultMessage: 'Last test run'
});