"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorFailedTests = exports.FAILED_TESTS_LABEL = exports.BRUSH_LABEL = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _use_monitor_query_filters = require("../hooks/use_monitor_query_filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_errors/failed_tests.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorFailedTests = ({
  time,
  allowBrushing = true
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const {
    queryIdFilter,
    locationFilter
  } = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  const {
    errorStateId
  } = (0, _reactRouterDom.useParams)();
  const [, updateUrl] = (0, _hooks.useUrlParams)();
  if (!queryIdFilter && !errorStateId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: 'failedTestsLineSeries',
    customHeight: '120px',
    reportType: "heatmap",
    axisTitlesVisibility: {
      x: false,
      yRight: false,
      yLeft: false
    },
    legendIsVisible: false,
    attributes: [{
      time,
      reportDefinitions: {
        ...queryIdFilter,
        ...(errorStateId ? {
          'state.id': [errorStateId]
        } : {})
      },
      filters: locationFilter,
      dataType: 'synthetics',
      selectedMetricField: 'failed_tests',
      name: FAILED_TESTS_LABEL
    }],
    onBrushEnd: ({
      range
    }) => {
      if (allowBrushing) {
        updateUrl({
          dateRangeStart: (0, _moment.default)(range[0]).toISOString(),
          dateRangeEnd: (0, _moment.default)(range[1]).toISOString()
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      marginLeft: 10
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, FAILED_TESTS_LABEL)), allowBrushing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }, BRUSH_LABEL))));
};
exports.MonitorFailedTests = MonitorFailedTests;
const FAILED_TESTS_LABEL = exports.FAILED_TESTS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.failedTests', {
  defaultMessage: 'Failed tests'
});
const BRUSH_LABEL = exports.BRUSH_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.brushArea', {
  defaultMessage: 'Brush an area for higher fidelity'
});