"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDetailsLastRun = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_monitor_latest_ping = require("./hooks/use_monitor_latest_ping");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_details_last_run.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorDetailsLastRun = () => {
  const {
    latestPing,
    loading: pingsLoading
  } = (0, _use_monitor_latest_ping.useMonitorLatestPing)();
  let description = latestPing ? (0, _moment.default)(latestPing['@timestamp']).fromNow() : '--';
  if (!latestPing && pingsLoading) {
    description = /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 19
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: LAST_RUN_LABEL,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: (0, _moment.default)(latestPing === null || latestPing === void 0 ? void 0 : latestPing['@timestamp']).format('LLL'),
        position: "bottom",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 15
        }
      }, description))
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
};
exports.MonitorDetailsLastRun = MonitorDetailsLastRun;
const LAST_RUN_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorLastRun.lastRunLabel', {
  defaultMessage: 'Last run'
});