"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorQueryId = void 0;
var _runtime_types = require("../../../../../../common/runtime_types");
var _use_selected_monitor = require("./use_selected_monitor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorQueryId = () => {
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  return monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.MONITOR_QUERY_ID];
};
exports.useMonitorQueryId = useMonitorQueryId;