"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useJourneySteps = void 0;
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _react = require("react");
var _browser_steps_list = require("../../common/monitor_test_result/browser_steps_list");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useJourneySteps = (checkGroup, lastRefresh, stepIndexArg) => {
  var _journeyData$steps, _failedStep$synthetic;
  const {
    stepIndex: stepIndexUrl,
    checkGroupId: urlCheckGroup
  } = (0, _reactRouterDom.useParams)();
  const stepIndex = stepIndexArg !== null && stepIndexArg !== void 0 ? stepIndexArg : stepIndexUrl;
  const checkGroupId = checkGroup !== null && checkGroup !== void 0 ? checkGroup : urlCheckGroup;
  const journeyData = (0, _reactRedux.useSelector)((0, _state.selectBrowserJourney)(checkGroupId));
  const loading = (0, _reactRedux.useSelector)((0, _state.selectBrowserJourneyLoading)(checkGroupId));
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    if (checkGroupId) {
      dispatch(_state.fetchJourneyAction.get({
        checkGroup: checkGroupId
      }));
    }
  }, [checkGroupId, dispatch, lastRefresh]);
  const stepEnds = ((_journeyData$steps = journeyData === null || journeyData === void 0 ? void 0 : journeyData.steps) !== null && _journeyData$steps !== void 0 ? _journeyData$steps : []).filter(_browser_steps_list.isStepEnd);
  const failedStep = journeyData === null || journeyData === void 0 ? void 0 : journeyData.steps.find(step => {
    var _step$synthetics, _step$synthetics$step;
    return ((_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : (_step$synthetics$step = _step$synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.status) === 'failed';
  });
  const stepLabels = stepEnds.map(stepEnd => {
    var _stepEnd$synthetics$s, _stepEnd$synthetics, _stepEnd$synthetics$s2;
    return (_stepEnd$synthetics$s = stepEnd === null || stepEnd === void 0 ? void 0 : (_stepEnd$synthetics = stepEnd.synthetics) === null || _stepEnd$synthetics === void 0 ? void 0 : (_stepEnd$synthetics$s2 = _stepEnd$synthetics.step) === null || _stepEnd$synthetics$s2 === void 0 ? void 0 : _stepEnd$synthetics$s2.name) !== null && _stepEnd$synthetics$s !== void 0 ? _stepEnd$synthetics$s : '';
  });
  const currentStep = stepIndex ? stepEnds.find(step => {
    var _step$synthetics2, _step$synthetics2$ste;
    return ((_step$synthetics2 = step.synthetics) === null || _step$synthetics2 === void 0 ? void 0 : (_step$synthetics2$ste = _step$synthetics2.step) === null || _step$synthetics2$ste === void 0 ? void 0 : _step$synthetics2$ste.index) === Number(stepIndex);
  }) : undefined;
  const isFailedStep = (failedStep === null || failedStep === void 0 ? void 0 : (_failedStep$synthetic = failedStep.synthetics) === null || _failedStep$synthetic === void 0 ? void 0 : _failedStep$synthetic.step) && failedStep.synthetics.step.index === Number(stepIndex);
  return {
    data: journeyData,
    loading: loading !== null && loading !== void 0 ? loading : false,
    stepEnds,
    stepLabels,
    currentStep,
    failedStep,
    isFailedStep,
    isFailed: false
  };
};
exports.useJourneySteps = useJourneySteps;