"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useValidateField = useValidateField;
var _react = require("react");
var _reactHookForm = require("react-hook-form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useValidateField({
  fieldKey,
  validation,
  validationError,
  required,
  dependencies,
  customHook
}) {
  var _hookProps, _hookProps2, _hookProps3, _hookProps4, _validation;
  const {
    getValues,
    formState,
    getFieldState,
    watch
  } = (0, _reactHookForm.useFormContext)();
  const fieldState = getFieldState(fieldKey, formState);
  const fieldValue = getValues(fieldKey);
  const fieldError = fieldState.error;
  const isFieldTouched = fieldState.isTouched;
  const isFieldInvalid = fieldState.invalid;
  const [dependenciesFieldMeta, setDependenciesFieldMeta] = (0, _react.useState)({});
  let dependenciesValues = [];
  if (dependencies) {
    dependenciesValues = watch(dependencies);
  }
  (0, _react.useEffect)(() => {
    if (dependencies) {
      dependencies.forEach(dependency => {
        setDependenciesFieldMeta(prevState => ({
          ...prevState,
          [dependency]: getFieldState(dependency)
        }));
      });
    }
    // run effect when dependencies values change, to get the most up-to-date meta state
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(dependenciesValues || []), dependencies, getFieldState]);
  let hookFn = () => {};
  let hookProps;
  if (customHook) {
    hookProps = customHook(fieldValue);
    hookFn = hookProps.func;
  }
  const {
    [(_hookProps = hookProps) === null || _hookProps === void 0 ? void 0 : _hookProps.fieldKey]: hookResult
  } = hookFn((_hookProps2 = hookProps) === null || _hookProps2 === void 0 ? void 0 : _hookProps2.params) || {};
  const hookErrorContent = (_hookProps3 = hookProps) === null || _hookProps3 === void 0 ? void 0 : _hookProps3.error;
  const hookError = hookResult ? (_hookProps4 = hookProps) === null || _hookProps4 === void 0 ? void 0 : _hookProps4.error : undefined;
  const {
    validate: fieldValidator,
    ...fieldRules
  } = (_validation = validation === null || validation === void 0 ? void 0 : validation(dependenciesValues)) !== null && _validation !== void 0 ? _validation : {};
  const validatorsWithHook = {
    validHook: () => hookError ? hookErrorContent : true,
    ...(fieldValidator !== null && fieldValidator !== void 0 ? fieldValidator : {})
  };
  const showFieldAsInvalid = isFieldInvalid && (isFieldTouched || formState.isSubmitted);
  return {
    dependenciesValues,
    dependenciesFieldMeta,
    isInvalid: showFieldAsInvalid,
    error: showFieldAsInvalid ? (fieldError === null || fieldError === void 0 ? void 0 : fieldError.message) || validationError : undefined,
    rules: {
      required,
      ...(fieldRules !== null && fieldRules !== void 0 ? fieldRules : {}),
      validate: validatorsWithHook
    }
  };
}