"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_form_wrapped = require("../../../../../hooks/use_form_wrapped");
var _types = require("../types");
var _defaults = require("./defaults");
var _submit = require("./submit");
var _disclaimer = require("./disclaimer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/form/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const MonitorForm = ({
  children,
  defaultValues,
  space,
  readOnly = false,
  canUsePublicLocations
}) => {
  const methods = (0, _use_form_wrapped.useFormWrapped)({
    mode: 'onSubmit',
    reValidateMode: 'onSubmit',
    defaultValues: (0, _defaults.formatDefaultFormValues)(defaultValues) || (0, _defaults.getDefaultFormFields)(space)[_types.FormMonitorType.MULTISTEP],
    shouldFocusError: false
  });
  const {
    spaces: spacesApi
  } = (0, _public.useKibana)().services;
  const ContextWrapper = (0, _react.useMemo)(() => spacesApi ? spacesApi.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spacesApi]);

  /* React hook form doesn't seem to register a field
   * as dirty until validation unless dirtyFields is subscribed to */
  const {
    formState: {
      isSubmitted,
      errors,
      dirtyFields: _
    }
  } = methods;
  return /*#__PURE__*/_react.default.createElement(ContextWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, methods, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: Boolean(isSubmitted && Object.keys(errors).length),
    component: "form",
    noValidate: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_submit.ActionBar, {
    readOnly: readOnly,
    canUsePublicLocations: canUsePublicLocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_disclaimer.Disclaimer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  })));
};
exports.MonitorForm = MonitorForm;