"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MONITOR_TYPE_CONFIG = exports.FIELD = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/fleet-plugin/common");
var _eui = require("@elastic/eui");
var _create_maintenance_windows_btn = require("../fields/maintenance_windows/create_maintenance_windows_btn");
var _kibana_service = require("../../../../../utils/kibana_service");
var _throttling_config_field = require("../fields/throttling/throttling_config_field");
var _field_wrappers = require("./field_wrappers");
var _use_monitor_name = require("../../../hooks/use_monitor_name");
var _types = require("../types");
var _constants = require("../constants");
var _defaults = require("./defaults");
var _validation = require("./validation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/form/field_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getScheduleContent = (value, seconds) => {
  if (seconds) {
    return _i18n.i18n.translate('xpack.synthetics.monitorConfig.schedule.seconds.label', {
      defaultMessage: 'Every {value, number} {value, plural, one {second} other {seconds}}',
      values: {
        value
      }
    });
  }
  if (value > 60) {
    return _i18n.i18n.translate('xpack.synthetics.monitorConfig.schedule.label', {
      defaultMessage: 'Every {value, number} {value, plural, one {hour} other {hours}}',
      values: {
        value: value / 60
      }
    });
  } else {
    return _i18n.i18n.translate('xpack.synthetics.monitorConfig.schedule.minutes.label', {
      defaultMessage: 'Every {value, number} {value, plural, one {minute} other {minutes}}',
      values: {
        value
      }
    });
  }
};
const getSchedules = monitorType => {
  const minutes = _constants.ALLOWED_SCHEDULES_IN_MINUTES.map(value => ({
    value,
    text: getScheduleContent(parseInt(value, 10))
  }));
  const allowSeconds = monitorType === _types.MonitorTypeEnum.HTTP || monitorType === _types.MonitorTypeEnum.TCP || monitorType === _types.MonitorTypeEnum.ICMP;
  if (allowSeconds) {
    const seconds = _constants.ALLOWED_SCHEDULES_IN_SECONDS.map(value => ({
      value,
      text: getScheduleContent(parseInt(value, 10), true)
    }));
    return [...seconds, ...minutes];
  } else {
    return minutes;
  }
};
const MONITOR_TYPE_CONFIG = exports.MONITOR_TYPE_CONFIG = {
  [_types.FormMonitorType.MULTISTEP]: {
    id: 'syntheticsMonitorTypeMultistep',
    'data-test-subj': 'syntheticsMonitorTypeMultistep',
    label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.multiStep.label', {
      defaultMessage: 'Multistep'
    }),
    value: _types.FormMonitorType.MULTISTEP,
    descriptionTitle: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.multiStep.title', {
      defaultMessage: 'Multistep Browser Journey'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.multiStep.description', {
      defaultMessage: 'Navigate through multiple steps or pages to test key user flows from a real browser.'
    }),
    link: 'https://www.elastic.co/guide/en/observability/current/synthetics-journeys.html',
    icon: 'videoPlayer',
    beta: false
  },
  [_types.FormMonitorType.SINGLE]: {
    id: 'syntheticsMonitorTypeSingle',
    'data-test-subj': 'syntheticsMonitorTypeSingle',
    label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.singlePage.label', {
      defaultMessage: 'Single Page'
    }),
    value: _types.FormMonitorType.SINGLE,
    descriptionTitle: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.singlePage.title', {
      defaultMessage: 'Single Page Browser Test'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.singlePage.description', {
      defaultMessage: 'Test a single page load including all objects on the page from a real web browser.'
    }),
    link: 'https://www.elastic.co/guide/en/observability/current/synthetics-journeys.html',
    icon: 'videoPlayer',
    beta: false
  },
  [_types.FormMonitorType.HTTP]: {
    id: 'syntheticsMonitorTypeHTTP',
    'data-test-subj': 'syntheticsMonitorTypeHTTP',
    label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.http.label', {
      defaultMessage: 'HTTP Ping'
    }),
    value: _types.FormMonitorType.HTTP,
    descriptionTitle: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.http.title', {
      defaultMessage: 'HTTP Ping'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.http.description', {
      defaultMessage: 'A lightweight API check to validate the availability of a web service or endpoint.'
    }),
    link: 'https://elastic.co/guide/en/observability/current/synthetics-lightweight.html',
    icon: 'online',
    beta: false
  },
  [_types.FormMonitorType.TCP]: {
    id: 'syntheticsMonitorTypeTCP',
    'data-test-subj': 'syntheticsMonitorTypeTCP',
    label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.tcp.label', {
      defaultMessage: 'TCP Ping'
    }),
    value: _types.FormMonitorType.TCP,
    descriptionTitle: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.tcp.title', {
      defaultMessage: 'TCP Ping'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.tcp.description', {
      defaultMessage: 'A lightweight API check to validate the availability of a web service or endpoint.'
    }),
    link: 'https://www.elastic.co/guide/en/observability/current/synthetics-lightweight.html',
    icon: 'online',
    beta: false
  },
  [_types.FormMonitorType.ICMP]: {
    id: 'syntheticsMonitorTypeICMP',
    'data-test-subj': 'syntheticsMonitorTypeICMP',
    label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.icmp.label', {
      defaultMessage: 'ICMP Ping'
    }),
    value: _types.FormMonitorType.ICMP,
    descriptionTitle: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.icmp.title', {
      defaultMessage: 'ICMP Ping'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.icmp.description', {
      defaultMessage: 'A lightweight API check to validate the availability of a web service or endpoint.'
    }),
    link: 'https://www.elastic.co/guide/en/observability/current/synthetics-lightweight.html',
    icon: 'online',
    beta: false
  }
};
const FIELD = readOnly => {
  var _kibanaService$coreSt, _kibanaService$coreSt2, _kibanaService$coreSt3;
  return {
    [_types.ConfigKey.FORM_MONITOR_TYPE]: {
      fieldKey: _types.ConfigKey.FORM_MONITOR_TYPE,
      required: true,
      component: _field_wrappers.MonitorTypeRadioGroup,
      ariaLabel: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.label', {
        defaultMessage: 'Monitor type'
      }),
      controlled: true,
      props: ({
        field,
        reset,
        space
      }) => ({
        onChange: (_, monitorType) => {
          const defaultFields = (0, _defaults.getDefaultFormFields)(space)[monitorType];
          reset(defaultFields);
        },
        selectedOption: field === null || field === void 0 ? void 0 : field.value,
        options: Object.values(MONITOR_TYPE_CONFIG)
      }),
      validation: () => ({
        required: true
      })
    },
    [`urls__single`]: {
      fieldKey: _types.ConfigKey.URLS,
      required: true,
      component: _field_wrappers.FieldText,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.urlsSingle.label', {
        defaultMessage: 'Website URL'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.urlsSingle.helpText', {
        defaultMessage: 'For example, https://www.elastic.co.'
      }),
      controlled: true,
      dependencies: [_types.ConfigKey.NAME],
      props: ({
        setValue,
        dependenciesFieldMeta,
        isEdit,
        trigger
      }) => {
        return {
          'data-test-subj': 'syntheticsMonitorConfigURL',
          onChange: async event => {
            setValue(_types.ConfigKey.URLS, event.target.value, {
              shouldTouch: true
            });
            if (!dependenciesFieldMeta[_types.ConfigKey.NAME].isDirty && !isEdit) {
              setValue(_types.ConfigKey.NAME, event.target.value, {
                shouldTouch: true
              });
            }
            await trigger();
          },
          readOnly
        };
      }
    },
    [`urls__http`]: {
      fieldKey: _types.ConfigKey.URLS,
      required: true,
      component: _field_wrappers.FieldText,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.urls.label', {
        defaultMessage: 'URL'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.urls.helpText', {
        defaultMessage: 'For example, your service endpoint.'
      }),
      controlled: true,
      dependencies: [_types.ConfigKey.NAME],
      props: ({
        setValue,
        trigger,
        dependenciesFieldMeta,
        isEdit
      }) => {
        return {
          onChange: async event => {
            setValue(_types.ConfigKey.URLS, event.target.value, {
              shouldTouch: true
            });
            if (!dependenciesFieldMeta[_types.ConfigKey.NAME].isDirty && !isEdit) {
              setValue(_types.ConfigKey.NAME, event.target.value, {
                shouldTouch: true
              });
              await trigger();
            }
          },
          'data-test-subj': 'syntheticsMonitorConfigURL',
          readOnly
        };
      }
    },
    [`hosts__tcp`]: {
      fieldKey: _types.ConfigKey.HOSTS,
      required: true,
      component: _field_wrappers.FieldText,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.hostsTCP.label', {
        defaultMessage: 'Host:Port'
      }),
      controlled: true,
      dependencies: [_types.ConfigKey.NAME],
      props: ({
        setValue,
        trigger,
        dependenciesFieldMeta,
        isEdit
      }) => {
        return {
          onChange: async event => {
            setValue(_types.ConfigKey.HOSTS, event.target.value, {
              shouldTouch: true
            });
            if (!dependenciesFieldMeta[_types.ConfigKey.NAME].isDirty && !isEdit) {
              setValue(_types.ConfigKey.NAME, event.target.value, {
                shouldTouch: true
              });
            }
            await trigger();
          },
          'data-test-subj': 'syntheticsMonitorConfigHost',
          readOnly
        };
      }
    },
    [`hosts__icmp`]: {
      fieldKey: _types.ConfigKey.HOSTS,
      required: true,
      component: _field_wrappers.FieldText,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.hostsICMP.label', {
        defaultMessage: 'Host'
      }),
      controlled: true,
      dependencies: [_types.ConfigKey.NAME],
      props: ({
        setValue,
        trigger,
        dependenciesFieldMeta,
        isEdit
      }) => {
        return {
          onChange: async event => {
            setValue(_types.ConfigKey.HOSTS, event.target.value, {
              shouldTouch: true
            });
            if (!dependenciesFieldMeta[_types.ConfigKey.NAME].isDirty && !isEdit) {
              setValue(_types.ConfigKey.NAME, event.target.value, {
                shouldTouch: true
              });
            }
            await trigger();
          },
          'data-test-subj': 'syntheticsMonitorConfigHost',
          readOnly
        };
      }
    },
    [_types.ConfigKey.NAME]: {
      fieldKey: _types.ConfigKey.NAME,
      required: true,
      component: _field_wrappers.FieldText,
      controlled: true,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.name.label', {
        defaultMessage: 'Monitor name'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.name.helpText', {
        defaultMessage: 'Choose a name to help identify this monitor in the future.'
      }),
      dependencies: [_types.ConfigKey.URLS, _types.ConfigKey.HOSTS],
      customHook: value => ({
        fieldKey: 'nameAlreadyExists',
        func: _use_monitor_name.useMonitorName,
        params: {
          search: value
        },
        error: _i18n.i18n.translate('xpack.synthetics.monitorConfig.name.existsError', {
          defaultMessage: 'Monitor name already exists'
        })
      }),
      validation: () => ({
        validate: {
          notEmpty: value => !Boolean(value.trim()) ? _i18n.i18n.translate('xpack.synthetics.monitorConfig.name.error', {
            defaultMessage: 'Monitor name is required'
          }) : true
        }
      }),
      error: _i18n.i18n.translate('xpack.synthetics.monitorConfig.name.error', {
        defaultMessage: 'Monitor name is required'
      }),
      props: () => ({
        'data-test-subj': 'syntheticsMonitorConfigName',
        readOnly
      })
    },
    ['schedule.number']: {
      fieldKey: `schedule.number`,
      required: true,
      component: _field_wrappers.Select,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.frequency.label', {
        defaultMessage: 'Frequency'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.frequency.helpText', {
        defaultMessage: 'How often do you want to run this test? Higher frequencies will increase your total cost.'
      }),
      props: ({
        formState
      }) => {
        var _formState$defaultVal;
        return {
          'data-test-subj': 'syntheticsMonitorConfigSchedule',
          options: getSchedules((_formState$defaultVal = formState.defaultValues) === null || _formState$defaultVal === void 0 ? void 0 : _formState$defaultVal[_types.ConfigKey.MONITOR_TYPE]),
          disabled: readOnly
        };
      }
    },
    [_types.ConfigKey.LOCATIONS]: {
      fieldKey: _types.ConfigKey.LOCATIONS,
      required: true,
      controlled: true,
      component: _field_wrappers.ComboBox,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.locations.label', {
        defaultMessage: 'Locations'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.locations.helpText', {
        defaultMessage: 'Where do you want to run this test from? Additional locations will increase your total cost.'
      }),
      props: ({
        field,
        setValue,
        locations,
        trigger
      }) => {
        return {
          options: Object.values(locations).map(location => ({
            label: location.label,
            id: location.id,
            isServiceManaged: location.isServiceManaged || false,
            isInvalid: location.isInvalid,
            disabled: location.isInvalid
          })),
          selectedOptions: Object.values((field === null || field === void 0 ? void 0 : field.value) || {}).map(location => {
            var _ref, _locations$find;
            return {
              color: location.isInvalid || !locations.some(s => s.id === location.id) ? 'danger' : location.isServiceManaged ? 'default' : 'primary',
              label: (_ref = location.label || (locations === null || locations === void 0 ? void 0 : (_locations$find = locations.find(loc => location.id === loc.id)) === null || _locations$find === void 0 ? void 0 : _locations$find.label)) !== null && _ref !== void 0 ? _ref : location.id,
              id: location.id || '',
              isServiceManaged: location.isServiceManaged || false
            };
          }),
          'data-test-subj': 'syntheticsMonitorConfigLocations',
          onChange: async updatedValues => {
            const valuesToSave = updatedValues.map(({
              id,
              label,
              isServiceManaged
            }) => ({
              id,
              label,
              isServiceManaged
            }));
            setValue(_types.ConfigKey.LOCATIONS, valuesToSave);
            await trigger(_types.ConfigKey.LOCATIONS);
          },
          isDisabled: readOnly,
          renderOption: (option, searchValue) => {
            return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
              anchorProps: {
                style: {
                  width: '100%'
                }
              },
              content: option.isInvalid ? _i18n.i18n.translate('xpack.synthetics.monitorConfig.locations.attachedPolicy', {
                defaultMessage: 'The attached agent policy for this location has been deleted.'
              }) : '',
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 474,
                columnNumber: 13
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
              gutterSize: "s",
              alignItems: "center",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 487,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 488,
                columnNumber: 17
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
              search: searchValue,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 489,
                columnNumber: 19
              }
            }, option.label)), option.isInvalid && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
              grow: false,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 492,
                columnNumber: 19
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
              color: "danger",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 493,
                columnNumber: 21
              }
            }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.locations.invalid', {
              defaultMessage: 'Invalid'
            }))), !option.isServiceManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
              grow: false,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 501,
                columnNumber: 19
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
              color: "primary",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 502,
                columnNumber: 21
              }
            }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.locations.private', {
              defaultMessage: 'Private'
            })))));
          }
        };
      }
    },
    [_types.ConfigKey.ENABLED]: {
      fieldKey: _types.ConfigKey.ENABLED,
      component: _field_wrappers.Switch,
      controlled: true,
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.edit.enabled.label', {
        defaultMessage: `When disabled, the monitor doesn't run any tests. You can enable it at any time.`
      }),
      props: ({
        setValue,
        field,
        trigger,
        formState
      }) => {
        var _formState$defaultVal2;
        const isProjectMonitor = ((_formState$defaultVal2 = formState.defaultValues) === null || _formState$defaultVal2 === void 0 ? void 0 : _formState$defaultVal2[_types.ConfigKey.MONITOR_SOURCE_TYPE]) === _types.SourceType.PROJECT;
        return {
          id: 'syntheticsMontiorConfigIsEnabled',
          label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.enabled.label', {
            defaultMessage: 'Enable Monitor'
          }),
          checked: (field === null || field === void 0 ? void 0 : field.value) || false,
          onChange: async event => {
            setValue(_types.ConfigKey.ENABLED, !!event.target.checked);
            await trigger(_types.ConfigKey.ENABLED);
          },
          'data-test-subj': 'syntheticsEnableSwitch',
          // enabled is an allowed field for read only
          disabled: !isProjectMonitor && readOnly
        };
      }
    },
    [_constants.AlertConfigKey.STATUS_ENABLED]: {
      fieldKey: _constants.AlertConfigKey.STATUS_ENABLED,
      component: _field_wrappers.Switch,
      controlled: true,
      props: ({
        setValue,
        field,
        trigger,
        formState
      }) => {
        var _formState$defaultVal3;
        const isProjectMonitor = ((_formState$defaultVal3 = formState.defaultValues) === null || _formState$defaultVal3 === void 0 ? void 0 : _formState$defaultVal3[_types.ConfigKey.MONITOR_SOURCE_TYPE]) === _types.SourceType.PROJECT;
        return {
          id: 'syntheticsMonitorConfigIsAlertEnabled',
          label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.disabledAlerting.label', {
            defaultMessage: 'Enable status alerts on this monitor'
          }),
          checked: (field === null || field === void 0 ? void 0 : field.value) || false,
          onChange: async event => {
            setValue(_constants.AlertConfigKey.STATUS_ENABLED, !!event.target.checked);
            await trigger(_constants.AlertConfigKey.STATUS_ENABLED);
          },
          'data-test-subj': 'syntheticsAlertStatusSwitch',
          // alert config is an allowed field for read only
          disabled: !isProjectMonitor && readOnly
        };
      }
    },
    [_constants.AlertConfigKey.TLS_ENABLED]: {
      fieldKey: _constants.AlertConfigKey.TLS_ENABLED,
      component: _field_wrappers.Switch,
      controlled: true,
      props: ({
        setValue,
        field,
        trigger,
        formState
      }) => {
        var _formState$defaultVal4;
        const isProjectMonitor = ((_formState$defaultVal4 = formState.defaultValues) === null || _formState$defaultVal4 === void 0 ? void 0 : _formState$defaultVal4[_types.ConfigKey.MONITOR_SOURCE_TYPE]) === _types.SourceType.PROJECT;
        return {
          id: 'syntheticsMonitorConfigIsTlsAlertEnabled',
          label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.create.alertTlsEnabled.label', {
            defaultMessage: 'Enable TLS alerts on this monitor.'
          }),
          checked: (field === null || field === void 0 ? void 0 : field.value) || false,
          onChange: async event => {
            setValue(_constants.AlertConfigKey.TLS_ENABLED, !!event.target.checked);
            await trigger(_constants.AlertConfigKey.TLS_ENABLED);
          },
          'data-test-subj': 'syntheticsAlertStatusSwitch',
          // alert config is an allowed field for read only
          disabled: !isProjectMonitor && readOnly
        };
      }
    },
    [_types.ConfigKey.TAGS]: {
      fieldKey: _types.ConfigKey.TAGS,
      component: _field_wrappers.FormattedComboBox,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.tags.label', {
        defaultMessage: 'Tags'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.tags.helpText', {
        defaultMessage: 'A list of tags that will be sent with each monitor event. Useful for searching and segmenting data.'
      }),
      controlled: true,
      props: ({
        field
      }) => ({
        selectedOptions: (field === null || field === void 0 ? void 0 : field.value) || [],
        isDisabled: readOnly
      })
    },
    [_types.ConfigKey.TIMEOUT]: {
      fieldKey: _types.ConfigKey.TIMEOUT,
      component: _field_wrappers.FieldNumber,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.timeout.label', {
        defaultMessage: 'Timeout in seconds'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.timeout.helpText', {
        defaultMessage: 'The total time allowed for testing the connection and exchanging data.'
      }),
      props: () => ({
        'data-test-subj': 'syntheticsMonitorConfigTimeout',
        min: 1,
        step: 'any',
        readOnly
      }),
      dependencies: [_types.ConfigKey.SCHEDULE],
      validation: ([schedule]) => ({
        validate: {
          validTimeout: value => {
            switch (true) {
              case value < 0:
                return _i18n.i18n.translate('xpack.synthetics.monitorConfig.timeout.greaterThan0Error', {
                  defaultMessage: 'Timeout must be greater than or equal to 0.'
                });
              case value > parseFloat(schedule.number) * 60:
                return _i18n.i18n.translate('xpack.synthetics.monitorConfig.timeout.scheduleError', {
                  defaultMessage: 'Timeout must be less than the monitor frequency.'
                });
              case !Boolean(`${value}`.match(_validation.FLOATS_ONLY)):
                return _i18n.i18n.translate('xpack.synthetics.monitorConfig.timeout.formatError', {
                  defaultMessage: 'Timeout is invalid.'
                });
              default:
                return true;
            }
          }
        }
      })
    },
    [_types.ConfigKey.APM_SERVICE_NAME]: {
      fieldKey: _types.ConfigKey.APM_SERVICE_NAME,
      component: _field_wrappers.FieldText,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.apmServiceName.label', {
        defaultMessage: 'APM service name'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.apmServiceName.helpText', {
        defaultMessage: 'Corresponds to the service.name ECS field from APM. Set this to enable integrations between APM and Synthetics data.'
      }),
      controlled: true,
      props: () => ({
        'data-test-subj': 'syntheticsMonitorConfigAPMServiceName',
        readOnly
      })
    },
    [_types.ConfigKey.NAMESPACE]: {
      fieldKey: _types.ConfigKey.NAMESPACE,
      component: _field_wrappers.FieldText,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.namespace.label', {
        defaultMessage: 'Data stream namespace'
      }),
      helpText: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 668,
          columnNumber: 7
        }
      }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.namespace.helpText', {
        defaultMessage: "Change the default namespace. This setting changes the name of the monitor's data stream. "
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsFIELDLearnMoreLink",
        href: "https://www.elastic.co/guide/en/fleet/current/data-streams.html",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 673,
          columnNumber: 9
        }
      }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.namespace.learnMore', {
        defaultMessage: 'Learn more'
      }))),
      controlled: true,
      props: () => ({
        readOnly
      }),
      validation: () => ({
        validate: {
          validNamespace: namespace => (0, _common.isValidNamespace)(namespace).error
        }
      })
    },
    [_types.ConfigKey.MAX_REDIRECTS]: {
      fieldKey: _types.ConfigKey.MAX_REDIRECTS,
      component: _field_wrappers.FieldNumber,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.maxRedirects.label', {
        defaultMessage: 'Max redirects'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.maxRedirects.helpText', {
        defaultMessage: 'The total number of redirects to follow.'
      }),
      props: () => ({
        'data-test-subj': 'syntheticsMonitorConfigMaxRedirects',
        min: 0,
        max: 10,
        step: 1,
        readOnly
      }),
      validation: () => ({
        min: 0,
        max: 10,
        pattern: _validation.WHOLE_NUMBERS_ONLY
      }),
      error: _i18n.i18n.translate('xpack.synthetics.monitorConfig.maxRedirects.error', {
        defaultMessage: 'Max redirects is invalid.'
      })
    },
    [_types.ConfigKey.WAIT]: {
      fieldKey: _types.ConfigKey.WAIT,
      component: _field_wrappers.FieldNumber,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.wait.label', {
        defaultMessage: 'Wait'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.wait.helpText', {
        defaultMessage: 'The duration to wait before emitting another ICMP Echo Request if no response is received.'
      }),
      props: () => ({
        'data-test-subj': 'syntheticsMonitorConfigWait',
        min: 1,
        step: 1,
        readOnly
      }),
      validation: () => ({
        min: 1,
        pattern: _validation.WHOLE_NUMBERS_ONLY
      }),
      error: _i18n.i18n.translate('xpack.synthetics.monitorConfig.wait.error', {
        defaultMessage: 'Wait duration is invalid.'
      })
    },
    [_types.ConfigKey.USERNAME]: {
      fieldKey: _types.ConfigKey.USERNAME,
      component: _field_wrappers.FieldText,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.username.label', {
        defaultMessage: 'Username'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.username.helpText', {
        defaultMessage: 'Username for authenticating with the server.'
      }),
      props: () => ({
        readOnly
      })
    },
    [_types.ConfigKey.PASSWORD]: {
      fieldKey: _types.ConfigKey.PASSWORD,
      component: _field_wrappers.FieldPassword,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.password.label', {
        defaultMessage: 'Password'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.password.helpText', {
        defaultMessage: 'Password for authenticating with the server.'
      }),
      props: () => ({
        readOnly
      })
    },
    [_types.ConfigKey.PROXY_URL]: {
      fieldKey: _types.ConfigKey.PROXY_URL,
      component: _field_wrappers.FieldText,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.proxyUrl.label', {
        defaultMessage: 'Proxy URL'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.proxyUrl.helpText', {
        defaultMessage: 'HTTP proxy URL'
      }),
      props: () => ({
        readOnly
      })
    },
    [_types.ConfigKey.REQUEST_METHOD_CHECK]: {
      fieldKey: _types.ConfigKey.REQUEST_METHOD_CHECK,
      component: _field_wrappers.Select,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.requestMethod.label', {
        defaultMessage: 'Request method'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.requestMethod.helpText', {
        defaultMessage: 'The HTTP method to use.'
      }),
      props: () => ({
        options: Object.keys(_types.HTTPMethod).map(method => ({
          value: method,
          text: method
        })),
        disabled: readOnly
      })
    },
    [_types.ConfigKey.REQUEST_HEADERS_CHECK]: {
      fieldKey: _types.ConfigKey.REQUEST_HEADERS_CHECK,
      component: _field_wrappers.HeaderField,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.requestHeaders.label', {
        defaultMessage: 'Request headers'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.requestHeaders.helpText', {
        defaultMessage: 'A dictionary of additional HTTP headers to send. By default the client will set the User-Agent header to identify itself.'
      }),
      controlled: true,
      validation: () => ({
        validate: {
          validHeaders: headers => (0, _validation.validateHeaders)(headers) ? _i18n.i18n.translate('xpack.synthetics.monitorConfig.requestHeaders.error', {
            defaultMessage: 'Header key must be a valid HTTP token.'
          }) : true
        }
      }),
      dependencies: [_types.ConfigKey.REQUEST_BODY_CHECK],
      error: _i18n.i18n.translate('xpack.synthetics.monitorConfig.requestHeaders.error', {
        defaultMessage: 'Header key must be a valid HTTP token.'
      }),
      // contentMode is optional for other implementations, but required for this implementation of this field
      props: ({
        dependencies
      }) => {
        const [requestBody] = dependencies;
        return {
          'data-test-subj': 'syntheticsHeaderFieldRequestHeaders',
          readOnly,
          contentMode: !!(requestBody !== null && requestBody !== void 0 && requestBody.value) ? requestBody.type : undefined
        };
      }
    },
    [_types.ConfigKey.REQUEST_BODY_CHECK]: {
      fieldKey: _types.ConfigKey.REQUEST_BODY_CHECK,
      component: _field_wrappers.RequestBodyField,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.requestBody.label', {
        defaultMessage: 'Request body'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.requestBody.helpText', {
        defaultMessage: 'Request body content.'
      }),
      controlled: true,
      props: () => ({
        readOnly
      })
    },
    [_types.ConfigKey.RESPONSE_HEADERS_INDEX]: {
      fieldKey: _types.ConfigKey.RESPONSE_HEADERS_INDEX,
      component: _field_wrappers.Checkbox,
      helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.monitorConfig.indexResponseHeaders.helpText",
        defaultMessage: "Controls the indexing of the HTTP response headers to ",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 857,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 861,
          columnNumber: 9
        }
      }, 'http.response.body.headers')),
      props: () => ({
        label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.indexResponseHeaders.label', {
          defaultMessage: 'Index response headers'
        }),
        id: 'syntheticsMonitorConfigResponseHeadersIndex',
        // checkbox needs an id or it won't work,
        disabled: readOnly
      }),
      controlled: true
    },
    [_types.ConfigKey.RESPONSE_BODY_INDEX]: {
      fieldKey: _types.ConfigKey.RESPONSE_BODY_INDEX,
      component: _field_wrappers.ResponseBodyIndexField,
      helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.monitorConfig.indexResponseBody.helpText",
        defaultMessage: "Controls the indexing of the HTTP response body contents to",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 878,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 882,
          columnNumber: 9
        }
      }, 'http.response.body.contents')),
      props: () => ({
        readOnly
      }),
      controlled: true
    },
    [_types.ConfigKey.RESPONSE_STATUS_CHECK]: {
      fieldKey: _types.ConfigKey.RESPONSE_STATUS_CHECK,
      component: _field_wrappers.FormattedComboBox,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseStatusCheck.label', {
        defaultMessage: 'Response status equals'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseStatusCheck.helpText', {
        defaultMessage: 'A list of expected status codes. Press enter to add a new code. 4xx and 5xx codes are considered down by default. Other codes are considered up.'
      }),
      controlled: true,
      props: ({
        field
      }) => ({
        selectedOptions: field === null || field === void 0 ? void 0 : field.value,
        isDisabled: readOnly
      }),
      validation: () => ({
        validate: {
          validResponseStatusCheck: value => {
            const validateFn = _validation.validate[_types.MonitorTypeEnum.HTTP][_types.ConfigKey.RESPONSE_STATUS_CHECK];
            if (validateFn) {
              return !validateFn({
                [_types.ConfigKey.RESPONSE_STATUS_CHECK]: value
              });
            }
          }
        }
      }),
      error: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseStatusCheck.error', {
        defaultMessage: 'Status code must contain digits only.'
      })
    },
    [_types.ConfigKey.RESPONSE_HEADERS_CHECK]: {
      fieldKey: _types.ConfigKey.RESPONSE_HEADERS_CHECK,
      component: _field_wrappers.HeaderField,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseHeadersCheck.label', {
        defaultMessage: 'Response headers contain'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseHeadersCheck.helpText', {
        defaultMessage: 'A list of expected response headers.'
      }),
      controlled: true,
      validation: () => ({
        validate: {
          validHeaders: headers => (0, _validation.validateHeaders)(headers) ? _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseHeadersCheck.error', {
            defaultMessage: 'Header key must be a valid HTTP token.'
          }) : true
        }
      }),
      props: () => ({
        'data-test-subj': 'syntheticsHeaderFieldResponseHeaders',
        readOnly
      })
    },
    [_types.ConfigKey.RESPONSE_BODY_CHECK_POSITIVE]: {
      fieldKey: _types.ConfigKey.RESPONSE_BODY_CHECK_POSITIVE,
      component: _field_wrappers.FormattedComboBox,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseBodyCheck.label', {
        defaultMessage: 'Response body contains'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseBodyCheck.helpText', {
        defaultMessage: 'A list of regular expressions to match the body output. Press enter to add a new expression. Only a single expression needs to match.'
      }),
      controlled: true,
      props: ({
        field
      }) => ({
        selectedOptions: field === null || field === void 0 ? void 0 : field.value,
        isDisabled: readOnly
      })
    },
    [_types.ConfigKey.RESPONSE_BODY_CHECK_NEGATIVE]: {
      fieldKey: _types.ConfigKey.RESPONSE_BODY_CHECK_NEGATIVE,
      component: _field_wrappers.FormattedComboBox,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseBodyCheckNegative.label', {
        defaultMessage: 'Response body does not contain'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseBodyCheckNegative.helpText', {
        defaultMessage: 'A list of regular expressions to match the the body output negatively. Press enter to add a new expression. Return match failed if single expression matches.'
      }),
      controlled: true,
      props: ({
        field
      }) => ({
        selectedOptions: field === null || field === void 0 ? void 0 : field.value,
        isDisabled: readOnly
      })
    },
    [_types.ConfigKey.RESPONSE_RECEIVE_CHECK]: {
      fieldKey: _types.ConfigKey.RESPONSE_RECEIVE_CHECK,
      component: _field_wrappers.FieldText,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseReceiveCheck.label', {
        defaultMessage: 'Response contains'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseReceiveCheck.helpText', {
        defaultMessage: 'The expected remote host response.'
      }),
      props: () => ({
        readOnly
      })
    },
    ['proxy_url__tcp']: {
      fieldKey: _types.ConfigKey.PROXY_URL,
      component: _field_wrappers.FieldText,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.proxyURLTCP.label', {
        defaultMessage: 'Proxy URL'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.proxyURLTCP.helpText', {
        defaultMessage: 'The URL of the SOCKS5 proxy to use when connecting to the server. The value must be a URL with a scheme of socks5://.'
      }),
      props: () => ({
        readOnly
      })
    },
    [_types.ConfigKey.REQUEST_SEND_CHECK]: {
      fieldKey: _types.ConfigKey.REQUEST_SEND_CHECK,
      component: _field_wrappers.FieldText,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.requestSendCheck.label', {
        defaultMessage: 'Request payload'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.requestSendCheck.helpText', {
        defaultMessage: 'A payload string to send to the remote host.'
      }),
      props: () => ({
        readOnly
      })
    },
    ['source.inline']: {
      fieldKey: 'source.inline',
      required: true,
      component: _field_wrappers.Source,
      ariaLabel: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorScript.label', {
        defaultMessage: 'Monitor script'
      }),
      controlled: true,
      props: ({
        isEdit
      }) => ({
        isEditFlow: isEdit
      }),
      validation: () => ({
        validate: {
          validScript: value => {
            var _value$script, _value$script2, _value$script3, _value$script4;
            if (!value.script) {
              return _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorScript.error', {
                defaultMessage: 'Monitor script is required'
              });
            }

            // return false if script contains import or require statement
            if ((_value$script = value.script) !== null && _value$script !== void 0 && _value$script.includes('import ') || (_value$script2 = value.script) !== null && _value$script2 !== void 0 && _value$script2.includes('require(') || (_value$script3 = value.script) !== null && _value$script3 !== void 0 && _value$script3.includes('journey(')) {
              return _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorScript.invalid', {
                defaultMessage: 'Monitor script is invalid. Inline scripts cannot be full journey scripts, they may only contain step definitions.'
              });
            }
            // should contain at least one step
            if (value.script && !((_value$script4 = value.script) !== null && _value$script4 !== void 0 && _value$script4.includes('step('))) {
              return _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorScript.invalid.oneStep', {
                defaultMessage: 'Monitor script is invalid. Inline scripts must contain at least one step definition.'
              });
            }
            return true;
          }
        }
      })
    },
    [_types.ConfigKey.PARAMS]: {
      fieldKey: _types.ConfigKey.PARAMS,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.params.label', {
        defaultMessage: 'Parameters'
      }),
      controlled: true,
      component: _field_wrappers.JSONEditor,
      props: () => ({
        id: 'syntheticsMonitorConfigParams',
        height: '100px',
        ariaLabel: _i18n.i18n.translate('xpack.synthetics.monitorConfig.paramsAria.label', {
          defaultMessage: 'Monitor params code editor'
        }),
        readOnly
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.monitorConfig.params.helpText",
        defaultMessage: "Use JSON to define parameters that can be referenced in your script with {paramsValue}",
        values: {
          paramsValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 1081,
              columnNumber: 24
            }
          }, 'params.value')
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1077,
          columnNumber: 7
        }
      }),
      validation: () => ({
        validate: {
          validParams: value => {
            const validateFn = _validation.validate[_types.MonitorTypeEnum.BROWSER][_types.ConfigKey.PARAMS];
            if (validateFn) {
              return validateFn({
                [_types.ConfigKey.PARAMS]: value
              }) ? _i18n.i18n.translate('xpack.synthetics.monitorConfig.params.error', {
                defaultMessage: 'Invalid JSON format'
              }) : true;
            }
            return true;
          }
        }
      })
    },
    [_types.ConfigKey.LABELS]: {
      fieldKey: _types.ConfigKey.LABELS,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.meta.label', {
        defaultMessage: 'Label fields'
      }),
      controlled: true,
      component: _field_wrappers.KeyValuePairsField,
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.meta.helpText', {
        defaultMessage: 'List of key-value pairs that will be sent with each monitor event. Useful for adding custom metadata to your monitor.'
      }),
      props: ({
        field,
        setValue,
        trigger
      }) => ({
        readOnly,
        keyLabel: _i18n.i18n.translate('xpack.synthetics.monitorConfig.field.key.label', {
          defaultMessage: 'Field'
        }),
        valueLabel: _i18n.i18n.translate('xpack.synthetics.monitorConfig.field.value.label', {
          defaultMessage: 'Value'
        }),
        addPairControlLabel: _i18n.i18n.translate('xpack.synthetics.monitorConfig.metaField.label', {
          defaultMessage: 'Add label field'
        }),
        onChange: async pairs => {
          const value = {};
          pairs.forEach(pair => {
            const [fieldKey, fieldValue] = pair;
            value[fieldKey] = String(fieldValue);
          });
          if (!(0, _lodash.isEqual)(value, field === null || field === void 0 ? void 0 : field.value)) {
            setValue(_types.ConfigKey.LABELS, value);
            await trigger(_types.ConfigKey.LABELS);
          }
        },
        defaultPairs: Object.entries((field === null || field === void 0 ? void 0 : field.value) || {})
      }),
      validation: () => ({
        validate: {
          validBodyJSON: value => {
            if (Object.entries(value).some(check => !check[0] || !check[1])) {
              return _i18n.i18n.translate('xpack.synthetics.monitorConfig.metaFields.error', {
                defaultMessage: 'This meta fields is not valid. Make sure that both the field and value are defined.'
              });
            }
            return true;
          }
        }
      })
    },
    isTLSEnabled: {
      fieldKey: 'isTLSEnabled',
      component: _field_wrappers.Switch,
      controlled: true,
      props: ({
        setValue,
        field
      }) => {
        return {
          id: 'syntheticsMontiorConfigIsTLSEnabledSwitch',
          label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.customTLS.label', {
            defaultMessage: 'Use custom TLS configuration'
          }),
          checked: (field === null || field === void 0 ? void 0 : field.value) || false,
          onChange: event => {
            setValue('isTLSEnabled', event.target.checked);
          },
          disabled: readOnly
        };
      }
    },
    [_types.ConfigKey.TLS_VERIFICATION_MODE]: {
      fieldKey: _types.ConfigKey.TLS_VERIFICATION_MODE,
      component: _field_wrappers.Select,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.verificationMode.label', {
        defaultMessage: 'Verification mode'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.verificationMode.helpText', {
        defaultMessage: 'Verifies that the provided certificate is signed by a trusted authority (CA) and also verifies that the server’s hostname (or IP address) matches the names identified within the certificate. If the Subject Alternative Name is empty, it returns an error.'
      }),
      hidden: dependencies => {
        const [isTLSEnabled] = dependencies;
        return !Boolean(isTLSEnabled);
      },
      dependencies: ['isTLSEnabled'],
      props: () => ({
        options: Object.values(_types.VerificationMode).map(method => ({
          value: method,
          text: method.toUpperCase()
        })),
        disabled: readOnly
      })
    },
    [_types.ConfigKey.TLS_VERSION]: {
      fieldKey: _types.ConfigKey.TLS_VERSION,
      component: _field_wrappers.ComboBox,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.tlsVersion.label', {
        defaultMessage: 'Supported TLS protocols'
      }),
      controlled: true,
      hidden: dependencies => {
        const [isTLSEnabled] = dependencies;
        return !Boolean(isTLSEnabled);
      },
      dependencies: ['isTLSEnabled'],
      props: ({
        field,
        setValue,
        trigger
      }) => {
        return {
          options: Object.values(_types.TLSVersion).map(version => ({
            label: version
          })),
          selectedOptions: Object.values((field === null || field === void 0 ? void 0 : field.value) || []).map(version => ({
            label: version
          })),
          onChange: async updatedValues => {
            setValue(_types.ConfigKey.TLS_VERSION, updatedValues.map(option => option.label));
            await trigger(_types.ConfigKey.TLS_VERSION);
          },
          isDisabled: readOnly
        };
      }
    },
    [_types.ConfigKey.TLS_CERTIFICATE_AUTHORITIES]: {
      fieldKey: _types.ConfigKey.TLS_CERTIFICATE_AUTHORITIES,
      component: _field_wrappers.TextArea,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.certificateAuthorities.label', {
        defaultMessage: 'Certificate authorities'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.certificateAuthorities.helpText', {
        defaultMessage: 'PEM-formatted custom certificate authorities.'
      }),
      hidden: dependencies => {
        const [isTLSEnabled] = dependencies;
        return !Boolean(isTLSEnabled);
      },
      dependencies: ['isTLSEnabled'],
      props: () => ({
        readOnly
      })
    },
    [_types.ConfigKey.TLS_CERTIFICATE]: {
      fieldKey: _types.ConfigKey.TLS_CERTIFICATE,
      component: _field_wrappers.TextArea,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.clientCertificate.label', {
        defaultMessage: 'Client certificate'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.clientCertificate.helpText', {
        defaultMessage: 'PEM-formatted certificate for TLS client authentication.'
      }),
      hidden: dependencies => {
        const [isTLSEnabled] = dependencies;
        return !Boolean(isTLSEnabled);
      },
      dependencies: ['isTLSEnabled'],
      props: () => ({
        readOnly
      })
    },
    [_types.ConfigKey.TLS_KEY]: {
      fieldKey: _types.ConfigKey.TLS_KEY,
      component: _field_wrappers.TextArea,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.clientKey.label', {
        defaultMessage: 'Client key'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.clientKey.helpText', {
        defaultMessage: 'PEM-formatted certificate key for TLS client authentication.'
      }),
      hidden: dependencies => {
        const [isTLSEnabled] = dependencies;
        return !Boolean(isTLSEnabled);
      },
      dependencies: ['isTLSEnabled'],
      props: () => ({
        readOnly
      })
    },
    [_types.ConfigKey.TLS_KEY_PASSPHRASE]: {
      fieldKey: _types.ConfigKey.TLS_KEY_PASSPHRASE,
      component: _field_wrappers.FieldPassword,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.clientKeyPassphrase.label', {
        defaultMessage: 'Client key passphrase'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.clientKeyPassphrase.helpText', {
        defaultMessage: 'Certificate key passphrase for TLS client authentication.'
      }),
      hidden: dependencies => {
        const [isTLSEnabled] = dependencies;
        return !Boolean(isTLSEnabled);
      },
      dependencies: ['isTLSEnabled'],
      props: () => ({
        readOnly
      })
    },
    [_types.ConfigKey.SCREENSHOTS]: {
      fieldKey: _types.ConfigKey.SCREENSHOTS,
      component: _field_wrappers.ButtonGroup,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.screenshotOptions.label', {
        defaultMessage: 'Screenshot options'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.screenshotOptions.helpText', {
        defaultMessage: 'Set this option to manage the screenshots captured by the synthetics agent.'
      }),
      controlled: true,
      props: ({
        field,
        setValue
      }) => ({
        idSelected: field === null || field === void 0 ? void 0 : field.value,
        onChange: option => setValue(_types.ConfigKey.SCREENSHOTS, option),
        options: Object.values(_types.ScreenshotOption).map(option => ({
          id: option,
          label: option.replace(/-/g, ' ')
        })),
        legend: _i18n.i18n.translate('xpack.synthetics.monitorConfig.screenshotOptions.label', {
          defaultMessage: 'Screenshot options'
        }),
        css: {
          textTransform: 'capitalize'
        },
        isDisabled: readOnly
      })
    },
    [_types.ConfigKey.TEXT_ASSERTION]: {
      fieldKey: _types.ConfigKey.TEXT_ASSERTION,
      component: _field_wrappers.FieldText,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.textAssertion.label', {
        defaultMessage: 'Text assertion'
      }),
      required: false,
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.textAssertion.helpText', {
        defaultMessage: 'Consider the page loaded when the specified text is rendered.'
      }),
      validation: () => ({
        required: false
      }),
      props: () => ({
        readOnly
      })
    },
    [_types.ConfigKey.THROTTLING_CONFIG]: {
      fieldKey: _types.ConfigKey.THROTTLING_CONFIG,
      component: _field_wrappers.ThrottlingWrapper,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.monitorConfig.throttlingDisabled.label",
        defaultMessage: "Connection profile ( {icon} Important information about throttling: {link})",
        values: {
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "alert",
            color: "warning",
            size: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 1348,
              columnNumber: 17
            }
          }),
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "syntheticsFIELDNoticeLink",
            href: 'https://github.com/elastic/synthetics/blob/main/docs/throttling.md',
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 1350,
              columnNumber: 13
            }
          }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.throttlingDisabled.link', {
            defaultMessage: 'notice'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1344,
          columnNumber: 7
        }
      }),
      required: true,
      controlled: true,
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.throttling.helpText', {
        defaultMessage: 'Simulate network throttling (download, upload, latency).'
      }),
      props: ({
        formState
      }) => {
        var _formState$defaultVal5;
        return {
          options: _throttling_config_field.PROFILE_OPTIONS,
          readOnly,
          disabled: false,
          initialValue: (_formState$defaultVal5 = formState.defaultValues) === null || _formState$defaultVal5 === void 0 ? void 0 : _formState$defaultVal5[_types.ConfigKey.THROTTLING_CONFIG]
        };
      },
      validation: () => ({
        required: true
      })
    },
    [_types.ConfigKey.PLAYWRIGHT_OPTIONS]: {
      fieldKey: _types.ConfigKey.PLAYWRIGHT_OPTIONS,
      component: _field_wrappers.JSONEditor,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.playwrightOptions.label', {
        defaultMessage: 'Playwright options'
      }),
      helpText: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1387,
          columnNumber: 7
        }
      }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.playwrightOptions.helpText', {
        defaultMessage: 'Configure Playwright agent with custom options. '
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsFIELDLearnMoreLink",
        href: (_kibanaService$coreSt = _kibana_service.kibanaService.coreStart.docLinks) === null || _kibanaService$coreSt === void 0 ? void 0 : (_kibanaService$coreSt2 = _kibanaService$coreSt.links) === null || _kibanaService$coreSt2 === void 0 ? void 0 : (_kibanaService$coreSt3 = _kibanaService$coreSt2.observability) === null || _kibanaService$coreSt3 === void 0 ? void 0 : _kibanaService$coreSt3.syntheticsCommandReference,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1391,
          columnNumber: 9
        }
      }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.playwrightOptions.learnMore', {
        defaultMessage: 'Learn more'
      }))),
      ariaLabel: _i18n.i18n.translate('xpack.synthetics.monitorConfig.playwrightOptions.codeEditor.json.ariaLabel', {
        defaultMessage: 'Playwright options JSON code editor'
      }),
      controlled: true,
      required: false,
      props: () => ({
        ariaLabel: _i18n.i18n.translate('xpack.synthetics.monitorConfig.playwrightOptions.codeEditor.json.ariaLabel', {
          defaultMessage: 'Playwright options JSON code editor'
        }),
        readOnly,
        id: 'syntheticsPlaywrightOptionsJSONCodeEditor'
      }),
      validation: () => ({
        validate: {
          validPlaywrightOptions: value => {
            const validateFn = _validation.validate[_types.MonitorTypeEnum.BROWSER][_types.ConfigKey.PLAYWRIGHT_OPTIONS];
            if (validateFn) {
              return validateFn({
                [_types.ConfigKey.PLAYWRIGHT_OPTIONS]: value
              }) ? _i18n.i18n.translate('xpack.synthetics.monitorConfig.playwrightOptions.error', {
                defaultMessage: 'Invalid JSON format'
              }) : true;
            }
            return true;
          }
        }
      })
    },
    [_types.ConfigKey.IGNORE_HTTPS_ERRORS]: {
      fieldKey: _types.ConfigKey.IGNORE_HTTPS_ERRORS,
      component: _field_wrappers.Switch,
      controlled: true,
      helpText: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1444,
          columnNumber: 7
        }
      }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.ignoreHttpsErrors.helpText', {
        defaultMessage: 'Turns off TLS/SSL validation in the synthetics browser. This is useful for testing sites that use self-signed certificates.'
      })),
      props: ({
        setValue
      }) => ({
        id: 'syntheticsMontiorConfigIgnoreHttpsErrors',
        label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.ignoreHttpsErrors.label', {
          defaultMessage: 'Ignore HTTPS errors'
        }),
        onChange: event => {
          setValue(_types.ConfigKey.IGNORE_HTTPS_ERRORS, !!event.target.checked);
        },
        disabled: readOnly
      })
    },
    [_types.ConfigKey.SYNTHETICS_ARGS]: {
      fieldKey: _types.ConfigKey.SYNTHETICS_ARGS,
      component: _field_wrappers.ComboBox,
      controlled: true,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.syntheticsArgs.label', {
        defaultMessage: 'Synthetics args'
      }),
      helpText: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1470,
          columnNumber: 7
        }
      }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.syntheticsArgs.helpText', {
        defaultMessage: 'Extra arguments to pass to the synthetics agent package. Takes a list of strings. This is useful in rare scenarios, and should not ordinarily need to be set.'
      })),
      props: ({
        setValue,
        field,
        trigger
      }) => ({
        id: 'syntheticsMontiorConfigSyntheticsArgs',
        selectedOptions: Object.values((field === null || field === void 0 ? void 0 : field.value) || []).map(arg => ({
          label: arg
        })),
        onChange: async updatedValues => {
          setValue(_types.ConfigKey.SYNTHETICS_ARGS, updatedValues.map(option => option.label));
          await trigger(_types.ConfigKey.SYNTHETICS_ARGS);
        },
        onCreateOption: newValue => {
          setValue(_types.ConfigKey.SYNTHETICS_ARGS, [...((field === null || field === void 0 ? void 0 : field.value) || []), newValue]);
        },
        isDisabled: readOnly
      })
    },
    [_types.ConfigKey.MODE]: {
      fieldKey: _types.ConfigKey.MODE,
      component: _field_wrappers.Select,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.mode.label', {
        defaultMessage: 'Mode'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.monitorConfig.syntheticsArgs.mode.helpText",
        defaultMessage: "If {any}, the monitor pings only one IP address for a hostname. If {all}, the monitor pings all resolvable IPs for a hostname. {all} is useful if you are using a DNS-load balancer and want to ping every IP address for the specified hostname.",
        values: {
          all: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 1506,
              columnNumber: 16
            }
          }, 'all'),
          any: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 1507,
              columnNumber: 16
            }
          }, 'any')
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1502,
          columnNumber: 7
        }
      }),
      props: () => ({
        options: Object.values(_types.Mode).map(value => ({
          value,
          text: value
        })),
        disabled: readOnly
      })
    },
    [_types.ConfigKey.RESPONSE_BODY_MAX_BYTES]: {
      fieldKey: _types.ConfigKey.RESPONSE_BODY_MAX_BYTES,
      component: _field_wrappers.FieldNumber,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseBodyMaxBytes.label', {
        defaultMessage: 'Response body max bytes'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseBodyMaxBytes.helpText', {
        defaultMessage: 'Controls the maximum size of the stored body contents.'
      }),
      hidden: dependencies => {
        const [responseBodyIndex] = dependencies || [];
        return responseBodyIndex === _types.ResponseBodyIndexPolicy.NEVER;
      },
      props: () => ({
        'data-test-subj': 'syntheticsMonitorConfigMaxBytes',
        min: 1,
        step: 'any',
        readOnly
      }),
      dependencies: [_types.ConfigKey.RESPONSE_BODY_INDEX]
    },
    [_types.ConfigKey.IPV4]: {
      fieldKey: _types.ConfigKey.IPV4,
      // also controls ipv6
      component: _field_wrappers.ComboBox,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.ipv4.label', {
        defaultMessage: 'IP protocols'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.ipv4.helpText', {
        defaultMessage: 'IP protocols to use when pinging the remote host.'
      }),
      controlled: true,
      dependencies: [_types.ConfigKey.IPV6],
      props: ({
        field,
        setValue,
        trigger,
        dependencies
      }) => {
        const [ipv6] = dependencies;
        const ipv4 = field === null || field === void 0 ? void 0 : field.value;
        const values = [];
        if (ipv4) {
          values.push('IPv4');
        }
        if (ipv6) {
          values.push('IPv6');
        }
        return {
          options: [{
            label: 'IPv4'
          }, {
            label: 'IPv6'
          }],
          selectedOptions: values.map(version => ({
            label: version
          })),
          onChange: async updatedValues => {
            setValue(_types.ConfigKey.IPV4, updatedValues.some(value => value.label === 'IPv4'));
            setValue(_types.ConfigKey.IPV6, updatedValues.some(value => value.label === 'IPv6'));
            await trigger([_types.ConfigKey.IPV4, _types.ConfigKey.IPV4]);
          },
          isDisabled: readOnly
        };
      }
    },
    [_types.ConfigKey.PROXY_HEADERS]: {
      fieldKey: _types.ConfigKey.PROXY_HEADERS,
      component: _field_wrappers.HeaderField,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.proxyHeaders.label', {
        defaultMessage: 'Proxy headers'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.proxyHeaders.helpText', {
        defaultMessage: 'Additional headers to send to proxies for CONNECT requests.'
      }),
      controlled: true,
      validation: () => ({
        validate: {
          validHeaders: headers => (0, _validation.validateHeaders)(headers) ? _i18n.i18n.translate('xpack.synthetics.monitorConfig.proxyHeaders.error', {
            defaultMessage: 'The header key must be a valid HTTP token.'
          }) : true
        }
      }),
      props: () => ({
        'data-test-subj': 'syntheticsHeaderFieldProxyHeaders',
        readOnly
      })
    },
    ['check.response.json']: {
      fieldKey: _types.ConfigKey.RESPONSE_JSON_CHECK,
      component: _field_wrappers.KeyValuePairsField,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseJSON.label', {
        defaultMessage: 'Response body contains JSON'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseJSON.helpText', {
        defaultMessage: 'A list of expressions executed against the body when parsed as JSON. The body size must be less than or equal to 100 MiB.'
      }),
      controlled: true,
      props: ({
        field,
        setValue,
        trigger
      }) => ({
        readOnly,
        keyLabel: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseJSON.key.label', {
          defaultMessage: 'Description'
        }),
        valueLabel: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseJSON.value.label', {
          defaultMessage: 'Expression'
        }),
        addPairControlLabel: _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseJSON.addPair.label', {
          defaultMessage: 'Add expression'
        }),
        onChange: async pairs => {
          const value = pairs.map(pair => {
            const [description, expression] = pair;
            return {
              description,
              expression
            };
          }).filter(pair => pair.description || pair.expression);
          if (!(0, _lodash.isEqual)(value, field === null || field === void 0 ? void 0 : field.value)) {
            setValue(_types.ConfigKey.RESPONSE_JSON_CHECK, value);
            await trigger(_types.ConfigKey.RESPONSE_JSON_CHECK);
          }
        },
        defaultPairs: (field === null || field === void 0 ? void 0 : field.value.map(check => [check.description, check.expression])) || []
      }),
      validation: () => ({
        validate: {
          validBodyJSON: value => {
            if (value.some(check => !check.expression || !check.description)) {
              return _i18n.i18n.translate('xpack.synthetics.monitorConfig.responseJSON.error', {
                defaultMessage: "This JSON expression isn't valid. Make sure that both the label and expression are defined."
              });
            }
            return true;
          }
        }
      })
    },
    [_types.ConfigKey.MAX_ATTEMPTS]: {
      fieldKey: _types.ConfigKey.MAX_ATTEMPTS,
      component: _field_wrappers.Switch,
      controlled: true,
      props: ({
        setValue,
        field,
        trigger
      }) => ({
        disabled: readOnly,
        id: 'syntheticsMonitorConfigMaxAttempts',
        label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.retest.label', {
          defaultMessage: 'Enable retest on failure'
        }),
        checked: (field === null || field === void 0 ? void 0 : field.value) === 2,
        onChange: async event => {
          const isChecked = !!event.target.checked;
          setValue(_types.ConfigKey.MAX_ATTEMPTS, isChecked ? 2 : 1);
          await trigger(_types.ConfigKey.MAX_ATTEMPTS);
        },
        'data-test-subj': 'syntheticsEnableAttemptSwitch'
      })
    },
    [_types.ConfigKey.MAINTENANCE_WINDOWS]: {
      fieldKey: _types.ConfigKey.MAINTENANCE_WINDOWS,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.maintenanceWindows.label', {
        defaultMessage: 'Maintenance windows'
      }),
      controlled: true,
      component: _field_wrappers.MaintenanceWindowsFieldWrapper,
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.maintenanceWindows.helpText', {
        defaultMessage: 'A list of maintenance windows to apply to this monitor. The monitor will not run during these times.'
      }),
      props: ({
        field,
        setValue,
        trigger
      }) => ({
        readOnly,
        onChange: async value => {
          setValue(_types.ConfigKey.MAINTENANCE_WINDOWS, value);
          await trigger(_types.ConfigKey.MAINTENANCE_WINDOWS);
        },
        fullWidth: true,
        value: field === null || field === void 0 ? void 0 : field.value
      }),
      labelAppend: /*#__PURE__*/_react.default.createElement(_create_maintenance_windows_btn.MaintenanceWindowsLink, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1708,
          columnNumber: 18
        }
      })
    },
    [_types.ConfigKey.KIBANA_SPACES]: {
      fieldKey: _types.ConfigKey.KIBANA_SPACES,
      component: _field_wrappers.KibanaSpacesWrapper,
      label: _i18n.i18n.translate('xpack.synthetics.monitorConfig.kibanaSpaces.label', {
        defaultMessage: 'Kibana spaces'
      }),
      helpText: _i18n.i18n.translate('xpack.synthetics.monitorConfig.kibanaSpaces.helpText', {
        defaultMessage: ' Current space should always be part of list, unless All spaces is selected.'
      }),
      controlled: true,
      props: ({
        field,
        setValue,
        trigger
      }) => ({
        readOnly,
        value: (field === null || field === void 0 ? void 0 : field.value) || [],
        onChange: async spaces => {
          setValue(_types.ConfigKey.KIBANA_SPACES, spaces);
          await trigger(_types.ConfigKey.KIBANA_SPACES);
        }
      })
    }
  };
};
exports.FIELD = FIELD;