"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPLOAD_SPEED_ERROR = exports.UPLOAD_LABEL = exports.ThrottlingUploadField = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _throttling_exceeded_callout = require("./throttling_exceeded_callout");
var _optional_label = require("../optional_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/fields/throttling/throttling_upload_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ThrottlingUploadField = ({
  readOnly,
  onFieldBlur,
  throttling,
  validate,
  handleInputChange,
  throttlingValue
}) => {
  var _validate$ConfigKey$T, _validate$ConfigKey$T2;
  const maxUpload = Number(_runtime_types.DEFAULT_BANDWIDTH_LIMIT[_runtime_types.BandwidthLimitKey.UPLOAD]);
  const exceedsUploadLimits = Number(throttlingValue.upload) > maxUpload;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: UPLOAD_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_label.OptionalLabel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 20
      }
    }),
    isInvalid: (validate ? !!(validate !== null && validate !== void 0 && (_validate$ConfigKey$T = validate[_runtime_types.ConfigKey.THROTTLING_CONFIG]) !== null && _validate$ConfigKey$T !== void 0 && _validate$ConfigKey$T.call(validate, throttling)) : false) || exceedsUploadLimits,
    error: exceedsUploadLimits ? /*#__PURE__*/_react.default.createElement(_throttling_exceeded_callout.ThrottlingExceededMessage, {
      throttlingField: "upload",
      limit: maxUpload,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    }) : UPLOAD_SPEED_ERROR,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: (validate ? !!(validate !== null && validate !== void 0 && (_validate$ConfigKey$T2 = validate[_runtime_types.ConfigKey.THROTTLING_CONFIG]) !== null && _validate$ConfigKey$T2 !== void 0 && _validate$ConfigKey$T2.call(validate, throttling)) : false) || exceedsUploadLimits,
    fullWidth: true,
    min: 0,
    step: 0.001,
    value: throttlingValue.upload,
    onChange: event => handleInputChange(event.target.value),
    onBlur: () => onFieldBlur === null || onFieldBlur === void 0 ? void 0 : onFieldBlur('upload'),
    "data-test-subj": "syntheticsBrowserUploadSpeed",
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }, "Mbps")),
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }));
};
exports.ThrottlingUploadField = ThrottlingUploadField;
const UPLOAD_LABEL = exports.UPLOAD_LABEL = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.browserAdvancedSettings.throttling.upload.label', {
  defaultMessage: 'Upload Speed'
});
const UPLOAD_SPEED_ERROR = exports.UPLOAD_SPEED_ERROR = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.browserAdvancedSettings.throttling.upload.error', {
  defaultMessage: 'Upload speed must be greater than zero.'
});