"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsDatePicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _hooks = require("../../../hooks");
var _constants = require("../../../../../../common/constants");
var _contexts = require("../../../contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/date_picker/synthetics_date_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SyntheticsDatePicker = ({
  fullWidth
}) => {
  const [getUrlParams, updateUrl] = (0, _hooks.useUrlParams)();
  const {
    commonlyUsedRanges
  } = (0, _react.useContext)(_contexts.SyntheticsSettingsContext);
  const {
    refreshApp
  } = (0, _react.useContext)(_contexts.SyntheticsRefreshContext);
  const {
    data
  } = (0, _public.useKibana)().services;

  // read time from state and update the url
  const sharedTimeState = data === null || data === void 0 ? void 0 : data.query.timefilter.timefilter.getTime();
  const {
    dateRangeStart: start,
    dateRangeEnd: end
  } = getUrlParams();
  (0, _react.useEffect)(() => {
    const {
      from,
      to
    } = sharedTimeState !== null && sharedTimeState !== void 0 ? sharedTimeState : {};
    if (from !== start || to !== end) {
      // if it's coming url. let's update shared state
      data === null || data === void 0 ? void 0 : data.query.timefilter.timefilter.setTime({
        from: start,
        to: end
      });
    }

    // only need at start, rest date picker on change fucn will take care off
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const euiCommonlyUsedRanges = commonlyUsedRanges ? commonlyUsedRanges.map(({
    from,
    to,
    display
  }) => {
    return {
      start: from,
      end: to,
      label: display
    };
  }) : _constants.CLIENT_DEFAULTS.COMMONLY_USED_DATE_RANGES;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    width: fullWidth ? 'full' : 'auto',
    start: start,
    end: end,
    commonlyUsedRanges: euiCommonlyUsedRanges,
    onTimeChange: ({
      start: startN,
      end: endN
    }) => {
      var _data$query, _data$query$timefilte;
      if (data !== null && data !== void 0 && (_data$query = data.query) !== null && _data$query !== void 0 && (_data$query$timefilte = _data$query.timefilter) !== null && _data$query$timefilte !== void 0 && _data$query$timefilte.timefilter) {
        data === null || data === void 0 ? void 0 : data.query.timefilter.timefilter.setTime({
          from: startN,
          to: endN
        });
      }
      updateUrl({
        dateRangeStart: startN,
        dateRangeEnd: endN
      });
      refreshApp();
    },
    onRefresh: refreshApp,
    updateButtonProps: {
      fill: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  });
};
exports.SyntheticsDatePicker = SyntheticsDatePicker;