"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocationStatusBadges = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_monitor_detail_locator = require("../../../hooks/use_monitor_detail_locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/components/location_status_badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_DISPLAY_COUNT = 3;
const LocationStatusBadges = ({
  loading,
  locations,
  configId
}) => {
  const [toDisplay, setToDisplay] = (0, _react.useState)(DEFAULT_DISPLAY_COUNT);
  if (loading && !locations) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 12
      }
    });
  }
  const locationsToDisplay = locations.slice(0, toDisplay);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    css: {
      maxWidth: 450,
      overflow: 'hidden'
    },
    wrap: true,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, locationsToDisplay.map(loc => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: loc.id,
    grow: false,
    css: {
      overflow: 'hidden',
      flexBasis: 'fit-content'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(MonitorDetailLinkForLocation, {
    configId: configId,
    locationId: loc.id,
    locationLabel: loc.label,
    color: loc.color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }))), locations.length > toDisplay && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: locations.length - toDisplay,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, locations.slice(toDisplay, locations.length).map(loc => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: loc.color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 19
      }
    }, loc.label))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    onClick: () => {
      setToDisplay(locations.length);
    },
    onClickAriaLabel: EXPAND_LOCATIONS_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }, "+", locations.length - toDisplay))), toDisplay > DEFAULT_DISPLAY_COUNT && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: locations.length - 3,
    grow: false,
    css: {
      overflow: 'hidden'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: COLLAPSE_LOCATIONS_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    onClick: () => {
      setToDisplay(DEFAULT_DISPLAY_COUNT);
    },
    onClickAriaLabel: COLLAPSE_LOCATIONS_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, "-", locations.length - DEFAULT_DISPLAY_COUNT))));
};
exports.LocationStatusBadges = LocationStatusBadges;
const MonitorDetailLinkForLocation = ({
  configId,
  locationId,
  locationLabel,
  color
}) => {
  const monitorDetailLinkUrl = (0, _use_monitor_detail_locator.useMonitorDetailLocator)({
    configId,
    locationId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: () => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "dot",
      color: color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 23
      }
    }),
    color: "hollow",
    href: monitorDetailLinkUrl !== null && monitorDetailLinkUrl !== void 0 ? monitorDetailLinkUrl : '/',
    "aria-label": _i18n.i18n.translate('xpack.synthetics.management.location.ariaLabel', {
      defaultMessage: 'View details for {locationLabel} location',
      values: {
        locationLabel
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, locationLabel);
};
const EXPAND_LOCATIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.locations.expand', {
  defaultMessage: 'Click to view remaining locations'
});
const COLLAPSE_LOCATIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.locations.collapse', {
  defaultMessage: 'Click to collapse locations'
});