"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCertStatus = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCertStatus = (expiryDate, issueDate) => {
  const expiryThreshold = _constants.DYNAMIC_SETTINGS_DEFAULTS.certExpirationThreshold;
  const ageThreshold = _constants.DYNAMIC_SETTINGS_DEFAULTS.certAgeThreshold;
  const certValidityDate = new Date(expiryDate !== null && expiryDate !== void 0 ? expiryDate : '');
  const isValidDate = !isNaN(certValidityDate.valueOf());
  if (!isValidDate) {
    return false;
  }
  const isExpiringSoon = (0, _moment.default)(certValidityDate).diff((0, _moment.default)(), 'days') < expiryThreshold;
  const isTooOld = (0, _moment.default)().diff((0, _moment.default)(issueDate), 'days') > ageThreshold;
  const isExpired = (0, _moment.default)(certValidityDate) < (0, _moment.default)();
  if (isExpired) {
    return _constants.CERT_STATUS.EXPIRED;
  }
  return isExpiringSoon ? _constants.CERT_STATUS.EXPIRING_SOON : isTooOld ? _constants.CERT_STATUS.TOO_OLD : _constants.CERT_STATUS.OK;
};
exports.useCertStatus = useCertStatus;