"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleViz = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _rule_monitors_table = require("./rule_monitors_table");
var _api_service = require("../../../../utils/api_service");
var _selectors = require("../../state/alert_rules/selectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/alerts/rule_viz.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleViz = ({
  dispatchedAction
}) => {
  const {
    data,
    loading
  } = (0, _reactRedux.useSelector)(_selectors.selectInspectRule);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    services: {
      inspector,
      uiSettings
    }
  } = (0, _public.useKibana)();
  const [isPopoverOpen, setIsPopoverOpen] = _react.default.useState(false);
  const {
    inspectorAdapters,
    addInspectorRequest
  } = (0, _public2.useInspectorContext)();
  const isInspectorEnabled = uiSettings.get(_common.enableInspectEsQueries);
  const inspect = () => {
    inspector.open(inspectorAdapters);
  };
  (0, _react.useEffect)(() => {
    _api_service.apiService.addInspectorRequest = addInspectorRequest;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    var _inspectorAdapters$re;
    inspectorAdapters === null || inspectorAdapters === void 0 ? void 0 : (_inspectorAdapters$re = inspectorAdapters.requests) === null || _inspectorAdapters$re === void 0 ? void 0 : _inspectorAdapters$re.reset();
    dispatch(dispatchedAction);
  }, [dispatchedAction, dispatch, inspectorAdapters === null || inspectorAdapters === void 0 ? void 0 : inspectorAdapters.requests]);
  const detailsButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsRuleVizInspectButton",
    onClick: inspect,
    iconType: "inspect",
    size: "xs",
    disabled: !isInspectorEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.synthetics.rules.details', {
    defaultMessage: 'Details'
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "search",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.synthetics.statusRuleViz.ruleAppliesToFlexItemLabel', {
    defaultMessage: 'Rule applies to '
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    button: loading ? undefined : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "syntheticsStatusRuleVizMonitorQueryIDsButton",
      size: "xs",
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.synthetics.statusRuleViz.monitorQueryIdsPopoverButton', {
      defaultMessage: '{total} existing {total, plural, one {monitor} other {monitors}}',
      values: {
        total: data === null || data === void 0 ? void 0 : data.monitors.length
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.synthetics.statusRuleViz.monitorsPopoverTitleLabel', {
    defaultMessage: 'Monitors'
  })), _i18n.i18n.translate('xpack.synthetics.statusRuleViz.ruleAppliesToFollowingPopoverLabel', {
    defaultMessage: 'Rule applies to following existing monitors.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_rule_monitors_table.RuleMonitorsTable, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }))), loading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, isInspectorEnabled ? detailsButton : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: inspectorDisabledTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, detailsButton))));
};
exports.RuleViz = RuleViz;
const inspectorDisabledTooltip = _i18n.i18n.translate('xpack.synthetics.rules.inspectorDisabled', {
  defaultMessage: 'Enable "Inspect ES queries" in Advanced Settings to see Details'
});