"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMonitorsOverviewPanelAction = createMonitorsOverviewPanelAction;
var _i18n = require("@kbn/i18n");
var _presentationContainers = require("@kbn/presentation-containers");
var _public = require("@kbn/ui-actions-plugin/public");
var _common = require("@kbn/observability-shared-plugin/common");
var _constants = require("../constants");
var _constants2 = require("./constants");
var _monitors_open_configuration = require("../common/monitors_open_configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createMonitorsOverviewPanelAction(coreStart, pluginStart) {
  return {
    id: _constants2.ADD_SYNTHETICS_MONITORS_OVERVIEW_ACTION_ID,
    grouping: _common.COMMON_OBSERVABILITY_GROUPING,
    order: 5,
    getIconType: () => 'play',
    isCompatible: async ({
      embeddable
    }) => {
      return (0, _presentationContainers.apiIsPresentationContainer)(embeddable);
    },
    execute: async ({
      embeddable
    }) => {
      if (!(0, _presentationContainers.apiIsPresentationContainer)(embeddable)) throw new _public.IncompatibleActionError();
      const initialState = await (0, _monitors_open_configuration.openMonitorConfiguration)({
        coreStart,
        pluginStart,
        title: _i18n.i18n.translate('xpack.synthetics.editSyntheticsOverviewEmbeddableTitle.overview.title', {
          defaultMessage: 'Create monitors overview'
        }),
        type: _constants.SYNTHETICS_MONITORS_EMBEDDABLE
      });
      try {
        embeddable.addNewPanel({
          panelType: _constants.SYNTHETICS_MONITORS_EMBEDDABLE,
          serializedState: {
            rawState: initialState
          }
        });
      } catch (e) {
        return Promise.reject();
      }
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.synthetics.syntheticsEmbeddable.monitors.ariaLabel', {
      defaultMessage: 'Monitors overview'
    })
  };
}