"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelector = FieldSelector;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactHookForm = require("react-hook-form");
var _use_fetch_synthetics_suggestions = require("../hooks/use_fetch_synthetics_suggestions");
var _optional_text = require("./optional_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/embeddables/common/field_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldSelector({
  dataTestSubj,
  label,
  name,
  placeholder,
  tooltip,
  required
}) {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const [search, setSearch] = (0, _react.useState)('');
  const {
    suggestions = [],
    isLoading
  } = (0, _use_fetch_synthetics_suggestions.useFetchSyntheticsSuggestions)({
    search,
    fieldName: name
  });
  const debouncedSearch = (0, _lodash.debounce)(value => setSearch(value), 200);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: !!tooltip ? /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 13
      }
    }, label, " ", tooltip) : label,
    isInvalid: getFieldState(name).invalid,
    fullWidth: true,
    labelAppend: !required ? /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 34
      }
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: "",
    name: name,
    control: control,
    rules: {
      required
    },
    render: ({
      field,
      fieldState
    }) => {
      const selectedOptions = !!Array.isArray(field.value) && field.value.length ? createSelectedOptions(field.value, suggestions) : [];
      return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
        "aria-label": placeholder,
        async: true,
        "data-test-subj": dataTestSubj,
        isClearable: true,
        fullWidth: true,
        isInvalid: fieldState.invalid,
        isLoading: isLoading,
        onChange: selected => {
          if (selected.length) {
            field.onChange(selected.map(option => ({
              label: option.label,
              value: option.value
            })));
            return;
          }
          field.onChange([]);
        },
        onSearchChange: value => debouncedSearch(value),
        options: createOptions(suggestions),
        placeholder: placeholder,
        selectedOptions: selectedOptions,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 15
        }
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  })));
}
function createOptions(suggestions = []) {
  return suggestions.map(suggestion => ({
    label: suggestion.label,
    value: suggestion.value
  })).sort((a, b) => String(a.label).localeCompare(b.label));
}
function createSelectedOptions(selected = [], suggestions = []) {
  return selected.map(value => {
    const suggestion = suggestions.find(s => s.value === value.value);
    if (!suggestion) {
      return {
        label: value.value,
        value: value.value
      };
    }
    return {
      label: suggestion.label,
      value: suggestion.value
    };
  });
}