"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SYNTHETICS_API_URLS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SYNTHETICS_API_URLS = exports.SYNTHETICS_API_URLS = /*#__PURE__*/function (SYNTHETICS_API_URLS) {
  SYNTHETICS_API_URLS["SYNTHETICS_MONITORS"] = "/api/synthetics/monitors";
  SYNTHETICS_API_URLS["GET_SYNTHETICS_MONITOR"] = "/api/synthetics/monitors/{monitorId}";
  SYNTHETICS_API_URLS["PRIVATE_LOCATIONS"] = "/api/synthetics/private_locations";
  SYNTHETICS_API_URLS["PARAMS"] = "/api/synthetics/params";
  SYNTHETICS_API_URLS["LATEST_TEST_RUN"] = "/api/synthetics/latest_test_run";
  SYNTHETICS_API_URLS["TEST_NOW_MONITOR"] = "/api/synthetics/monitor/test";
  SYNTHETICS_API_URLS["INDEX_TEMPLATES"] = "/internal/synthetics/service/index_templates";
  SYNTHETICS_API_URLS["SERVICE_LOCATIONS"] = "/internal/uptime/service/locations";
  SYNTHETICS_API_URLS["SYNTHETICS_MONITOR_INSPECT"] = "/internal/synthetics/service/monitor/inspect";
  SYNTHETICS_API_URLS["SYNTHETICS_ENABLEMENT"] = "/internal/synthetics/service/enablement";
  SYNTHETICS_API_URLS["RUN_ONCE_MONITOR"] = "/internal/synthetics/service/monitors/run_once";
  SYNTHETICS_API_URLS["SERVICE_ALLOWED"] = "/internal/synthetics/service/allowed";
  SYNTHETICS_API_URLS["SYNTHETICS_PROJECT_APIKEY"] = "/internal/synthetics/service/api_key";
  SYNTHETICS_API_URLS["SYNTHETICS_HAS_INTEGRATION_MONITORS"] = "/internal/synthetics/fleet/has_integration_monitors";
  SYNTHETICS_API_URLS["PRIVATE_LOCATIONS_CLEANUP"] = "/internal/synthetics/private_locations/_cleanup";
  SYNTHETICS_API_URLS["PINGS"] = "/internal/synthetics/pings";
  SYNTHETICS_API_URLS["MONITOR_STATUS_HEATMAP"] = "/internal/synthetics/ping_heatmap";
  SYNTHETICS_API_URLS["OVERVIEW_TRENDS"] = "/internal/synthetics/overview_trends";
  SYNTHETICS_API_URLS["OVERVIEW_STATUS"] = "/internal/synthetics/overview_status";
  SYNTHETICS_API_URLS["INDEX_SIZE"] = "/internal/synthetics/index_size";
  SYNTHETICS_API_URLS["AGENT_POLICIES"] = "/internal/synthetics/agent_policies";
  SYNTHETICS_API_URLS["PRIVATE_LOCATIONS_MONITORS"] = "/internal/synthetics/private_locations/monitors";
  SYNTHETICS_API_URLS["ENABLE_DEFAULT_ALERTING"] = "/internal/synthetics/enable_default_alerting";
  SYNTHETICS_API_URLS["GET_ACTIONS_CONNECTORS"] = "/internal/synthetics/get_actions_connectors";
  SYNTHETICS_API_URLS["GET_CONNECTOR_TYPES"] = "/internal/synthetics/get_connector_types";
  SYNTHETICS_API_URLS["JOURNEY"] = "/internal/synthetics/journey/{checkGroup}";
  SYNTHETICS_API_URLS["SYNTHETICS_SUCCESSFUL_CHECK"] = "/internal/synthetics/synthetics/check/success";
  SYNTHETICS_API_URLS["JOURNEY_SCREENSHOT_BLOCKS"] = "/internal/synthetics/journey/screenshot/block";
  SYNTHETICS_API_URLS["JOURNEY_FAILED_STEPS"] = "/internal/synthetics/journeys/failed_steps";
  SYNTHETICS_API_URLS["NETWORK_EVENTS"] = "/internal/synthetics/network_events";
  SYNTHETICS_API_URLS["JOURNEY_SCREENSHOT"] = "/internal/synthetics/journey/screenshot/{checkGroup}/{stepIndex}";
  SYNTHETICS_API_URLS["DELETE_PACKAGE_POLICY"] = "/internal/synthetics/monitor/policy/{packagePolicyId}";
  SYNTHETICS_API_URLS["FILTERS"] = "/internal/synthetics/monitor/filters";
  SYNTHETICS_API_URLS["TRIGGER_TASK_RUN"] = "/internal/synthetics/trigger_task_run/{taskType}";
  SYNTHETICS_API_URLS["CERTS"] = "/internal/synthetics/certs";
  SYNTHETICS_API_URLS["SUGGESTIONS"] = "/internal/synthetics/suggestions";
  SYNTHETICS_API_URLS["MAINTENANCE_WINDOWS"] = "/internal/synthetics/monitors/maintenance_windows";
  SYNTHETICS_API_URLS["SYNTHETICS_MONITORS_PROJECT"] = "/api/synthetics/project/{projectName}/monitors";
  SYNTHETICS_API_URLS["SYNTHETICS_MONITORS_PROJECT_UPDATE"] = "/api/synthetics/project/{projectName}/monitors/_bulk_update";
  SYNTHETICS_API_URLS["SYNTHETICS_MONITORS_PROJECT_DELETE"] = "/api/synthetics/project/{projectName}/monitors/_bulk_delete";
  SYNTHETICS_API_URLS["DYNAMIC_SETTINGS"] = "/api/synthetics/settings";
  SYNTHETICS_API_URLS["INSPECT_STATUS_RULE"] = "/internal/synthetics/inspect_status_rule";
  SYNTHETICS_API_URLS["INSPECT_TLS_RULE"] = "/internal/synthetics/inspect_tls_rule";
  return SYNTHETICS_API_URLS;
}({});