"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestStream = exports.Ingest = void 0;
var _zod = require("@kbn/zod");
var _base = require("../base");
var _base2 = require("./base");
var _model_validation = require("../validation/model_validation");
var _validation = require("../validation/validation");
var _classic = require("./classic");
var _wired = require("./wired");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable @typescript-eslint/no-namespace */
let IngestStream = exports.IngestStream = void 0;
(function (_IngestStream) {
  const all = _IngestStream.all = (0, _model_validation.joinValidation)(_base.BaseStream, [_wired.WiredStream, _classic.ClassicStream]);
  // Optimized implementation for Definition check - the fallback is a zod-based check
  all.Definition.is = stream => 'ingest' in stream;
})(IngestStream || (exports.IngestStream = IngestStream = {}));
const Ingest = exports.Ingest = (0, _validation.validation)(_base2.IngestBase.right, _zod.z.union([_wired.WiredIngest.right, _classic.ClassicIngest.right]));