"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestBaseStream = exports.IngestBase = void 0;
var _zod = require("@kbn/zod");
var _streamlang = require("@kbn/streamlang");
var _model_validation = require("../validation/model_validation");
var _validation = require("../validation/validation");
var _lifecycle = require("./lifecycle");
var _base = require("../base");
var _settings = require("./settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ingestStreamPrivilegesSchema = _zod.z.object({
  manage: _zod.z.boolean(),
  monitor: _zod.z.boolean(),
  view_index_metadata: _zod.z.boolean(),
  lifecycle: _zod.z.boolean(),
  simulate: _zod.z.boolean(),
  text_structure: _zod.z.boolean(),
  read_failure_store: _zod.z.boolean(),
  manage_failure_store: _zod.z.boolean()
});
const IngestBase = exports.IngestBase = (0, _validation.validation)(_zod.z.unknown(), _zod.z.object({
  lifecycle: _lifecycle.ingestStreamLifecycleSchema,
  processing: _streamlang.streamlangDSLSchema,
  settings: _settings.ingestStreamSettingsSchema
}));

/* eslint-disable @typescript-eslint/no-namespace */

const IngestBaseStream = exports.IngestBaseStream = (0, _model_validation.modelValidation)(_base.BaseStream, {
  Source: _zod.z.object({}),
  Definition: _zod.z.object({
    ingest: IngestBase.right
  }),
  GetResponse: _zod.z.object({
    privileges: ingestStreamPrivilegesSchema
  }),
  UpsertRequest: _zod.z.object({})
});