"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.storedFeatureSchema = void 0;
var _zod = require("@kbn/zod");
var _streamlang = require("@kbn/streamlang");
var _fields = require("./fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const storedFeatureSchema = exports.storedFeatureSchema = _zod.z.object({
  [_fields.FEATURE_UUID]: _zod.z.string(),
  [_fields.FEATURE_NAME]: _zod.z.string(),
  [_fields.FEATURE_DESCRIPTION]: _zod.z.string(),
  [_fields.FEATURE_FILTER]: _streamlang.conditionSchema,
  [_fields.STREAM_NAME]: _zod.z.string()
});