"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefinitionNotFoundError = void 0;
exports.isDefinitionNotFoundError = isDefinitionNotFoundError;
var _status_error = require("./status_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DefinitionNotFoundError extends _status_error.StatusError {
  constructor(message) {
    super(message, 404);
    this.name = 'DefinitionNotFoundError';
  }
}
exports.DefinitionNotFoundError = DefinitionNotFoundError;
function isDefinitionNotFoundError(error) {
  return error instanceof DefinitionNotFoundError;
}