"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.verifyQueries = verifyQueries;
var _esQuery = require("@kbn/es-query");
var _streamsSchema = require("@kbn/streams-schema");
var _pLimit = _interopRequireDefault(require("p-limit"));
var _query_helpers = require("../../../routes/internal/esql/query_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function verifyQueries(params, dependencies) {
  const {
    queries,
    definition,
    start,
    end
  } = params;
  const {
    esClient,
    logger
  } = dependencies;
  const validQueries = queries.filter(query => (0, _query_helpers.isKqlQueryValid)(query.kql));
  if (!queries.length) {
    return {
      totalCount: 0,
      queries: []
    };
  }
  const limiter = (0, _pLimit.default)(10);
  const [validQueriesWithCounts, totalCount] = await Promise.all([Promise.all(validQueries.map(query => limiter(async () => {
    return esClient.search('verify_query', {
      track_total_hits: true,
      index: (0, _streamsSchema.getIndexPatternsForStream)(definition),
      size: 0,
      timeout: '5s',
      query: {
        bool: {
          filter: [...(0, _esQuery.kqlQuery)(query.kql), ...(0, _query_helpers.rangeQuery)(start, end)]
        }
      }
    }).then(response => ({
      ...query,
      count: response.hits.total.value
    })).catch(() => {
      return {
        ...query,
        count: 0
      };
    });
  }))), esClient.search('verify_query', {
    track_total_hits: true,
    index: (0, _streamsSchema.getIndexPatternsForStream)(definition),
    size: 0,
    timeout: '5s'
  }).then(response => response.hits.total.value).catch(() => {
    return 0;
  })]);
  if (validQueriesWithCounts.length) {
    logger.debug(() => {
      return `Ran queries: ${validQueriesWithCounts.map(query => `- ${query.kql}: ${query.count}`).join('\n')}`;
    });
  }
  return {
    totalCount,
    queries: validQueriesWithCounts
  };
}