"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SignificantEventsGeneratedTable = SignificantEventsGeneratedTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _preview_data_spark_plot = require("../common/preview_data_spark_plot");
var _validate_query = require("../common/validate_query");
var _generated_event_preview = require("./generated_event_preview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/add_significant_event_flyout/generated_flow_form/significant_events_generated_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SignificantEventsGeneratedTable({
  generatedQueries,
  onEditQuery,
  setIsEditingQueries,
  selectedQueries,
  onSelectionChange,
  definition,
  isSubmitting,
  features,
  dataViews
}) {
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const [eventsInEditMode, setEventsInEditMode] = (0, _react.useState)([]);
  const setIsEditing = (0, _react.useCallback)((isEditing, query) => {
    const nextEventsInEditMode = isEditing ? [...eventsInEditMode, query.id] : eventsInEditMode.filter(id => id !== query.id);
    setEventsInEditMode(nextEventsInEditMode);
    setIsEditingQueries(nextEventsInEditMode.length > 0);
  }, [eventsInEditMode, setIsEditingQueries]);
  const toggleDetails = query => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[query.id]) {
      delete itemIdToExpandedRowMapValues[query.id];
    } else {
      itemIdToExpandedRowMapValues[query.id] = /*#__PURE__*/_react.default.createElement(_generated_event_preview.GeneratedEventPreview, {
        definition: definition,
        query: query,
        isEditing: eventsInEditMode.includes(query.id),
        setIsEditing: nextIsEditing => setIsEditing(nextIsEditing, query),
        onSave: onEditQuery,
        features: features,
        dataViews: dataViews,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 9
        }
      });
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  };
  (0, _react.useEffect)(() => {
    const copy = {
      ...itemIdToExpandedRowMap
    };
    for (const queryId of Object.keys(copy)) {
      const query = generatedQueries.find(q => q.id === queryId);
      copy[queryId] = /*#__PURE__*/_react.default.createElement(_generated_event_preview.GeneratedEventPreview, {
        definition: definition,
        query: query,
        isEditing: eventsInEditMode.includes(query.id),
        setIsEditing: nextIsEditing => setIsEditing(nextIsEditing, query),
        onSave: onEditQuery,
        features: features,
        dataViews: dataViews,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 9
        }
      });
    }
    setItemIdToExpandedRowMap(copy);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [eventsInEditMode, definition, onEditQuery, features, dataViews, generatedQueries]);
  const columns = [{
    align: 'right',
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.aiFlow.previewToggleColumn', {
      defaultMessage: 'Preview toggle'
    }))),
    mobileOptions: {
      header: false
    },
    render: query => {
      const itemIdToExpandedRowMapValues = {
        ...itemIdToExpandedRowMap
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => toggleDetails(query),
        "aria-label": itemIdToExpandedRowMapValues[query.id] ? 'Collapse' : 'Expand',
        iconType: itemIdToExpandedRowMapValues[query.id] ? 'arrowDown' : 'arrowRight',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'title',
    width: '30%',
    name: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.aiFlow.titleColumn', {
      defaultMessage: 'Title'
    }),
    render: (_, query) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 29
      }
    }, query.title)
  }, {
    width: '20%',
    field: 'feature',
    name: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.aiFlow.featureColumn', {
      defaultMessage: 'Feature'
    }),
    render: (_, item) => {
      var _item$feature;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 16
        }
      }, (_item$feature = item.feature) === null || _item$feature === void 0 ? void 0 : _item$feature.name);
    }
  }, {
    width: '30%',
    field: 'kql',
    name: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.aiFlow.queryColumn', {
      defaultMessage: 'Query'
    }),
    render: (_, item) => {
      var _item$kql;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "none",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 16
        }
      }, JSON.stringify((_item$kql = item.kql) === null || _item$kql === void 0 ? void 0 : _item$kql.query));
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.aiFlow.dataColumn', {
      defaultMessage: 'Data preview'
    }))),
    width: '20%',
    render: query => {
      const validation = (0, _validate_query.validateQuery)(query);
      return /*#__PURE__*/_react.default.createElement(_preview_data_spark_plot.PreviewDataSparkPlot, {
        definition: definition,
        query: query,
        isQueryValid: !validation.kql.isInvalid,
        showTitle: false,
        compressed: true,
        hideAxis: true,
        height: 40,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 11
        }
      });
    }
  }];
  const selection = {
    onSelectionChange,
    selected: selectedQueries,
    selectable: () => !isSubmitting
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableLayout: "auto",
    responsiveBreakpoint: false,
    items: generatedQueries,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    itemId: "id",
    rowHeader: "title",
    columns: columns,
    selection: selection,
    noItemsMessage: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.aiFlow.noQueriesMessage', {
      defaultMessage: 'No significant events queries generated'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 5
    }
  });
}