"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDeleteModal = StreamDeleteModal;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_delete_modal/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function StreamDeleteModal({
  onClose,
  onDelete,
  onCancel,
  name
}) {
  const {
    core: {
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const [isDeletingStream, setDeleteInProgress] = (0, _react.useState)(false);
  const [streamName, setStreamName] = (0, _react.useState)('');
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const handleDelete = async () => {
    try {
      setDeleteInProgress(true);
      await onDelete();
      setDeleteInProgress(false);
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.streams.streamDetailRouting.deleted', {
          defaultMessage: 'Stream deleted'
        })
      });
      onClose();
    } catch (error) {
      setDeleteInProgress(false);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.streams.failedToDelete', {
          defaultMessage: 'Failed to delete stream {id}',
          values: {
            id: name
          }
        })
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: onClose,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.deleteStreamModal.title', {
    defaultMessage: 'Are you sure you want to delete {stream} ?',
    values: {
      stream: name
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.deleteStreamModal.warningText",
      defaultMessage: "This action cannot be undone and permanently deletes the {stream} stream and all its contents. This action cannot be undone.",
      values: {
        stream: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: e => {
            e.currentTarget.blur();
            (0, _eui.copyToClipboard)(name);
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 94,
            columnNumber: 19
          }
        }, name, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "copy",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 100,
            columnNumber: 28
          }
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 13
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.deleteStreamModal.confirmationInputLabel', {
      defaultMessage: 'To confirm, type {stream}',
      values: {
        stream: name
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "streamsAppDeleteStreamModalStreamNameInput",
    onChange: e => setStreamName(e.target.value),
    fullWidth: true,
    name: 'stream-name-deletion',
    autoFocus: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isDisabled: isDeletingStream,
    onClick: onCancel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.deleteStreamModal.cancelButton', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: streamName !== name,
    isLoading: isDeletingStream,
    color: "danger",
    onClick: handleDelete,
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.deleteStreamModal.deleteButton', {
    defaultMessage: 'Delete'
  }))));
}