"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoSuggestionsCallout = NoSuggestionsCallout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _generate_suggestions_button = require("./generate_suggestions_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/review_suggestions_form/no_suggestions_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function NoSuggestionsCallout({
  aiFeatures,
  isLoadingSuggestions,
  onRegenerate,
  onDismiss
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.streams.streamDetailRouting.childStreamList.noSuggestionsTitle', {
      defaultMessage: 'No suggestions available'
    }),
    onDismiss: onDismiss,
    className: (0, _css.css)`
        min-block-size: auto; /* Prevent background clipping */
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.childStreamList.noSuggestionsDescription', {
    defaultMessage: 'Retry using a different time range.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_generate_suggestions_button.GenerateSuggestionButton, {
    iconType: "refresh",
    size: "s",
    onClick: onRegenerate,
    isLoading: isLoadingSuggestions,
    aiFeatures: aiFeatures,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.childStreamList.regenerateSuggestedPartitions', {
    defaultMessage: 'Regenerate'
  })));
}