"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureEventsData = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _streamlang = require("@kbn/streamlang");
var _common = require("@kbn/discover-plugin/common");
var _use_stream_feature_events_data = require("./hooks/use_stream_feature_events_data");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_stream_detail = require("../../../../hooks/use_stream_detail");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/stream_features/feature_events_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FeatureEventsData = ({
  feature
}) => {
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const events = (0, _use_stream_feature_events_data.useStreamFeatureEventsData)(feature);
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const useUrl = share.url.locators.useUrl;
  const {
    definition
  } = (0, _use_stream_detail.useStreamDetail)();
  const esqlQuery = `FROM ${(0, _streamsSchema.getIndexPatternsForStream)(definition.stream).join(',')}
      | WHERE ${(0, _streamlang.conditionToESQL)(feature.filter)}`;
  const discoverLink = useUrl(() => ({
    id: _common.DISCOVER_APP_LOCATOR,
    params: {
      query: {
        esql: esqlQuery
      },
      timeRange: {
        from: 'now-24h',
        to: 'now'
      }
    }
  }), [esqlQuery]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.identifiedFeatureEvents.label', {
    defaultMessage: 'Identified feature events'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, discoverLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    href: discoverLink,
    "aria-label": _i18n.i18n.translate('xpack.streams.identifiedFeatureEvents.viewAllLinkAriaLabel', {
      defaultMessage: 'Open in Discover'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.identifiedFeatureEvents.viewAllLinkText', {
    defaultMessage: 'Open in Discover'
  })) : null)), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 64
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartBaseTheme,
    showLegend: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "numbers",
    data: events,
    xAccessor: 0,
    yAccessors: [1],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  })));
};
exports.FeatureEventsData = FeatureEventsData;