"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataStreamStats = void 0;
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../../../hooks/use_streams_app_fetch");
var _get_calculated_stats = require("../helpers/get_calculated_stats");
var _use_ingestion_rate = require("./use_ingestion_rate");
var _format_bytes = require("../helpers/format_bytes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataStreamStats = ({
  definition,
  timeState
}) => {
  const {
    core,
    services: {
      dataStreamsClient
    },
    dependencies: {
      start: {
        data: {
          search
        },
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const statsFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => {
    var _dsStats$sizeBytes, _failureStore$stats$s, _failureStore$stats;
    const client = await dataStreamsClient;
    const [{
      dataStreamsStats: [dsStats]
    }, failureStore] = await Promise.all([client.getDataStreamsStats({
      datasetQuery: definition.stream.name,
      includeCreationDate: true
    }), streamsRepositoryClient.fetch('GET /internal/streams/{name}/failure_store/stats', {
      signal,
      params: {
        path: {
          name: definition.stream.name
        }
      }
    })]);
    if (!dsStats || !dsStats.creationDate) {
      return undefined;
    }
    const [dsAggregations, fsAggregations] = await Promise.all([(0, _use_ingestion_rate.getAggregations)({
      definition,
      timeState,
      core,
      search,
      signal
    }), failureStore.config.enabled ? (0, _use_ingestion_rate.getAggregations)({
      definition,
      timeState,
      core,
      search,
      signal,
      isFailureStore: true
    }) : undefined]);
    const dsSizeWithoutFs = Math.max(0, ((_dsStats$sizeBytes = dsStats.sizeBytes) !== null && _dsStats$sizeBytes !== void 0 ? _dsStats$sizeBytes : 0) - ((_failureStore$stats$s = failureStore === null || failureStore === void 0 ? void 0 : (_failureStore$stats = failureStore.stats) === null || _failureStore$stats === void 0 ? void 0 : _failureStore$stats.size) !== null && _failureStore$stats$s !== void 0 ? _failureStore$stats$s : 0));
    return {
      ds: {
        stats: {
          ...dsStats,
          sizeBytes: dsSizeWithoutFs,
          size: (0, _format_bytes.formatBytes)(dsSizeWithoutFs),
          ...(0, _get_calculated_stats.getCalculatedStats)({
            stats: {
              creationDate: dsStats.creationDate,
              totalDocs: dsStats.totalDocs,
              sizeBytes: dsSizeWithoutFs
            },
            timeState,
            buckets: dsAggregations === null || dsAggregations === void 0 ? void 0 : dsAggregations.buckets
          })
        },
        aggregations: dsAggregations
      },
      fs: {
        stats: failureStore.stats && failureStore.stats.creationDate ? {
          ...failureStore.stats,
          ...(0, _get_calculated_stats.getCalculatedStats)({
            stats: {
              creationDate: failureStore.stats.creationDate,
              totalDocs: failureStore.stats.count,
              sizeBytes: failureStore.stats.size
            },
            timeState,
            buckets: fsAggregations === null || fsAggregations === void 0 ? void 0 : fsAggregations.buckets
          })
        } : undefined,
        config: failureStore.config,
        aggregations: fsAggregations
      }
    };
  }, [dataStreamsClient, definition, streamsRepositoryClient, core, search, timeState], {
    withTimeRange: false,
    withRefresh: true
  });
  return {
    stats: statsFetch.value,
    isLoading: statsFetch.loading,
    refresh: statsFetch.refresh,
    error: statsFetch.error
  };
};
exports.useDataStreamStats = useDataStreamStats;