"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_RETENTION_VALUE = exports.DEFAULT_RETENTION_UNIT = void 0;
exports.DslField = DslField;
var _react = _interopRequireWildcard(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _helpers = require("../../helpers/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/general_data/modal/dsl.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isInvalidRetention = value => {
  const num = Number(value);
  return isNaN(num) || num < 1 || num % 1 > 0;
};
const DEFAULT_RETENTION_VALUE = exports.DEFAULT_RETENTION_VALUE = '90';
const DEFAULT_RETENTION_UNIT = exports.DEFAULT_RETENTION_UNIT = {
  name: 'Days',
  value: 'd'
};
function DslField({
  initialValue,
  isDisabled,
  setLifecycle,
  setSaveButtonDisabled
}) {
  var _existingRetention$va;
  const timeUnits = [{
    name: 'Days',
    value: 'd'
  }, {
    name: 'Hours',
    value: 'h'
  }, {
    name: 'Minutes',
    value: 'm'
  }, {
    name: 'Seconds',
    value: 's'
  }];
  const existingRetention = (0, _streamsSchema.isDslLifecycle)(initialValue) ? (0, _helpers.parseDuration)(initialValue.dsl.data_retention) : undefined;
  const [selectedUnit, setSelectedUnit] = (0, _react.useState)(existingRetention && timeUnits.find(unit => unit.value === existingRetention.unit) || DEFAULT_RETENTION_UNIT);
  const [retentionValue, setRetentionValue] = (0, _react.useState)(existingRetention && ((_existingRetention$va = existingRetention.value) === null || _existingRetention$va === void 0 ? void 0 : _existingRetention$va.toString()) || DEFAULT_RETENTION_VALUE);
  const [showUnitMenu, {
    on: openUnitMenu,
    off: closeUnitMenu
  }] = (0, _reactHooks.useBoolean)(false);
  const invalidRetention = (0, _react.useMemo)(() => isInvalidRetention(retentionValue), [retentionValue]);
  (0, _react.useEffect)(() => {
    var _existingRetention$va2;
    setSelectedUnit(existingRetention && timeUnits.find(unit => unit.value === existingRetention.unit) || DEFAULT_RETENTION_UNIT);
    setRetentionValue(existingRetention && ((_existingRetention$va2 = existingRetention.value) === null || _existingRetention$va2 === void 0 ? void 0 : _existingRetention$va2.toString()) || DEFAULT_RETENTION_VALUE);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [initialValue]);
  (0, _react.useEffect)(() => {
    if (!invalidRetention && retentionValue && selectedUnit.value) {
      setLifecycle({
        dsl: {
          data_retention: `${Number(retentionValue)}${selectedUnit.value}`
        }
      });
      setSaveButtonDisabled(false);
    } else {
      setSaveButtonDisabled(true);
    }
  }, [retentionValue, selectedUnit.value]); // eslint-disable-line react-hooks/exhaustive-deps

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "streamsAppDslModalDaysField",
    value: isDisabled && existingRetention ? existingRetention === null || existingRetention === void 0 ? void 0 : existingRetention.value : retentionValue,
    onChange: e => {
      setRetentionValue(e.target.value);
    },
    disabled: isDisabled,
    fullWidth: true,
    isInvalid: invalidRetention,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      isOpen: showUnitMenu,
      panelPaddingSize: "none",
      closePopover: closeUnitMenu,
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "streamsAppDslModalButton",
        disabled: isDisabled,
        iconType: "arrowDown",
        iconSide: "right",
        color: "text",
        onClick: openUnitMenu,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 15
        }
      }, selectedUnit.name),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: timeUnits.map(unit => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: unit.value,
        icon: selectedUnit.value === unit.value ? 'check' : 'empty',
        onClick: () => {
          closeUnitMenu();
          setSelectedUnit(unit);
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 17
        }
      }, unit.name)),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }), invalidRetention && !isDisabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.invalidRetentionValue', {
    defaultMessage: 'A positive integer is required'
  }))) : null);
}