"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageSizeCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _base_metric_card = require("../../common/base_metric_card");
var _format_bytes = require("../../helpers/format_bytes");
var _insufficient_privileges = require("../../../../insufficient_privileges/insufficient_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/general_data/cards/storage_size_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StorageSizeCard = ({
  definition,
  stats,
  statsError
}) => {
  var _definition$privilege, _definition$privilege2, _definition$privilege3;
  const hasPrivileges = (_definition$privilege = (_definition$privilege2 = definition.privileges) === null || _definition$privilege2 === void 0 ? void 0 : _definition$privilege2.monitor) !== null && _definition$privilege !== void 0 ? _definition$privilege : false;
  const metric = [{
    data: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: definition.privileges.monitor,
      title: "storageSize",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 9
      }
    }, statsError || !stats || !stats.sizeBytes ? '-' : (0, _format_bytes.formatBytes)(stats.sizeBytes)),
    subtitle: hasPrivileges ? _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.storageSize.docs', {
      defaultMessage: '{totalDocs} documents',
      values: {
        totalDocs: stats && stats.totalDocs ? (0, _eui.formatNumber)(stats.totalDocs, '0,0') : '-'
      }
    }) : null,
    'data-test-subj': 'storageSize'
  }];
  const inaccurateMetric = Boolean((stats === null || stats === void 0 ? void 0 : stats.hasFailureStore) && !((_definition$privilege3 = definition.privileges) !== null && _definition$privilege3 !== void 0 && _definition$privilege3.manage_failure_store));
  const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailLifecycle.storageSize.title",
    defaultMessage: "Storage size {tooltipIcon}",
    values: {
      tooltipIcon: inaccurateMetric && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "question",
        content: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.storageSize.tooltip', {
          defaultMessage: 'The storage size includes the failure store.'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 11
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_base_metric_card.BaseMetricCard, {
    title: title,
    metrics: metric,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 10
    }
  });
};
exports.StorageSizeCard = StorageSizeCard;