"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestionCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _insufficient_privileges = require("../../../../insufficient_privileges/insufficient_privileges");
var _base_metric_card = require("../../common/base_metric_card");
var _format_bytes = require("../../helpers/format_bytes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/failure_store/cards/ingestion_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IngestionCard = ({
  definition,
  stats,
  statsError
}) => {
  var _definition$privilege;
  const hasPrivileges = (_definition$privilege = definition.privileges) === null || _definition$privilege === void 0 ? void 0 : _definition$privilege.manage_failure_store;
  const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.failureStoreEnabled.failedIngestionCard.title",
    defaultMessage: "Failed ingestion averages {tooltipIcon}",
    values: {
      tooltipIcon: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "question",
        title: _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failedIngestionCard.tooltipTitle', {
          defaultMessage: 'How we calculate failed ingestion averages'
        }),
        content: _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failedIngestionCard.tooltip', {
          defaultMessage: 'Approximate average, calculated by extrapolating the ingestion rate from the failed documents on the selected time range and the average document size.'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 34,
          columnNumber: 11
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  });
  const metrics = [{
    data: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: hasPrivileges,
      title: _i18n.i18n.translate('xpack.streams.ingestionCard.privilegesWarningIconWrapper.dailyIngestionRateLabel', {
        defaultMessage: 'Daily ingestion rate'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, statsError || !stats || !stats.bytesPerDay ? '-' : (0, _format_bytes.formatBytes)(stats.bytesPerDay)),
    subtitle: _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failedIngestionCard.dailyAverage', {
      defaultMessage: 'Daily average'
    }),
    'data-test-subj': 'failureStoreIngestionDaily'
  }, {
    data: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: hasPrivileges,
      title: _i18n.i18n.translate('xpack.streams.ingestionCard.privilegesWarningIconWrapper.monthlyIngestionRateLabel', {
        defaultMessage: 'Monthly ingestion rate'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }, statsError || !stats || !stats.bytesPerDay ? '-' : (0, _format_bytes.formatBytes)(stats.bytesPerDay * 30)),
    subtitle: _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failedIngestionCard.monthlyAverage', {
      defaultMessage: 'Monthly average'
    }),
    'data-test-subj': 'failureStoreIngestionMonthly'
  }];
  return /*#__PURE__*/_react.default.createElement(_base_metric_card.BaseMetricCard, {
    title: title,
    metrics: metrics,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 10
    }
  });
};
exports.IngestionCard = IngestionCard;