"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectWhetherAnyProcessorBeforePersisted = exports.selectDraftProcessor = void 0;
var _reselect = require("reselect");
var _streamlang = require("@kbn/streamlang");
var _steps_state_machine = require("../steps_state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Selects the processor marked as the draft processor.
 */
const selectDraftProcessor = context => {
  const draft = context.stepRefs.find(stepRef => {
    const snapshot = stepRef.getSnapshot();
    return (0, _streamlang.isActionBlock)(snapshot.context.step) && (0, _steps_state_machine.isStepUnderEdit)(snapshot) && snapshot.context.isNew;
  });
  const snapshot = draft === null || draft === void 0 ? void 0 : draft.getSnapshot();
  return draft && (0, _streamlang.isActionBlock)(snapshot === null || snapshot === void 0 ? void 0 : snapshot.context.step) ? {
    processor: snapshot === null || snapshot === void 0 ? void 0 : snapshot.context.step,
    resources: snapshot === null || snapshot === void 0 ? void 0 : snapshot.context.resources
  } : {
    processor: undefined,
    resources: undefined
  };
};

/**
 * Selects whether there are any new processors before the persisted ones.
 */
exports.selectDraftProcessor = selectDraftProcessor;
const selectWhetherAnyProcessorBeforePersisted = exports.selectWhetherAnyProcessorBeforePersisted = (0, _reselect.createSelector)([context => context.stepRefs], processorsRefs => {
  return processorsRefs.map(ref => ref.getSnapshot()).some((snapshot, id, processorSnapshots) => {
    // Skip if this processor is already persisted
    if (!snapshot.context.isNew) return false;

    // Check if there are persisted processors after this position
    const hasPersistedAfter = processorSnapshots.slice(id + 1).some(({
      context
    }) => !context.isNew);
    return hasPersistedAfter;
  });
});