"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimulationPlayground = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _processor_outcome_preview = require("./processor_outcome_preview");
var _stream_enrichment_state_machine = require("./state_management/stream_enrichment_state_machine");
var _detected_fields_editor = require("./detected_fields_editor");
var _data_sources_list = require("./data_sources_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/simulation_playground.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SimulationPlayground = () => {
  const {
    refreshSimulation,
    viewSimulationPreviewData,
    viewSimulationDetectedFields
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const isViewingDataPreview = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.matches({
    ready: {
      enrichment: {
        displayingSimulation: 'viewDataPreview'
      }
    }
  }));
  const isViewingDetectedFields = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.matches({
    ready: {
      enrichment: {
        displayingSimulation: 'viewDetectedFields'
      }
    }
  }));
  const detectedFields = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.detectedSchemaFields);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: isViewingDataPreview,
    onClick: viewSimulationPreviewData,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "refresh",
      onClick: refreshSimulation,
      "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.refreshPreviewAriaLabel', {
        defaultMessage: 'Refresh data preview'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.dataPreview', {
    defaultMessage: 'Data preview'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: isViewingDetectedFields,
    onClick: viewSimulationDetectedFields,
    append: detectedFields.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 21
      }
    }, detectedFields.length) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.detectedFields', {
    defaultMessage: 'Detected fields'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_data_sources_list.DataSourcesList, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(ProgressBar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }), isViewingDataPreview && /*#__PURE__*/_react.default.createElement(_processor_outcome_preview.ProcessorOutcomePreview, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 32
    }
  }), isViewingDetectedFields && /*#__PURE__*/_react.default.createElement(_detected_fields_editor.DetectedFieldsEditor, {
    detectedFields: detectedFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 35
    }
  }));
};
exports.SimulationPlayground = SimulationPlayground;
const ProgressBar = () => {
  const isLoading = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.matches('debouncingChanges') || state.matches('runningSimulation'));
  return isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 23
    }
  });
};