"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/shared/field_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Generalized field selector component with autocomplete suggestions
 */
const FieldSelector = ({
  value,
  onChange,
  label,
  helpText,
  placeholder,
  disabled = false,
  compressed = false,
  fullWidth = false,
  dataTestSubj = 'streamsAppFieldSelector',
  isInvalid,
  error,
  suggestions = [],
  autoFocus
}) => {
  const comboBoxOptions = (0, _react.useMemo)(() => suggestions.map(suggestion => ({
    label: suggestion.name,
    value: suggestion.name,
    'data-test-subj': `field-suggestion-${suggestion.name}`
  })), [suggestions]);
  const selectedOptions = (0, _react.useMemo)(() => {
    if (!value) return [];
    const matchingSuggestion = comboBoxOptions.find(option => option.value === value);
    return matchingSuggestion ? [matchingSuggestion] : [{
      label: value,
      value
    }];
  }, [value, comboBoxOptions]);
  const handleSelectionChange = (0, _react.useCallback)(newSelectedOptions => {
    const selectedOption = newSelectedOptions[0];
    const newFieldValue = (selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.value) || '';
    onChange === null || onChange === void 0 ? void 0 : onChange(newFieldValue);
  }, [onChange]);
  const handleCreateOption = (0, _react.useCallback)(searchValue => {
    const normalizedValue = searchValue.trim();
    if (normalizedValue) {
      handleSelectionChange([{
        label: normalizedValue,
        value: normalizedValue
      }]);
    }
  }, [handleSelectionChange]);
  const defaultPlaceholder = _i18n.i18n.translate('xpack.streams.fieldSelector.defaultPlaceholder', {
    defaultMessage: 'Select or type a field name...'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    helpText: helpText,
    isInvalid: isInvalid,
    error: error,
    fullWidth: fullWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": dataTestSubj,
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : defaultPlaceholder,
    options: comboBoxOptions,
    selectedOptions: selectedOptions,
    onChange: handleSelectionChange,
    onCreateOption: handleCreateOption,
    singleSelection: {
      asPlainText: true
    },
    isInvalid: isInvalid,
    isDisabled: disabled,
    compressed: compressed,
    isClearable: true,
    fullWidth: fullWidth,
    customOptionText: _i18n.i18n.translate('xpack.streams.fieldSelector.customOptionText', {
      defaultMessage: 'Add {searchValue} as a custom field',
      values: {
        searchValue: '{searchValue}'
      }
    }),
    autoFocus: autoFocus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  })));
};
exports.FieldSelector = FieldSelector;