"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SamplePreviewTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_kibana = require("../../../../hooks/use_kibana");
var _errors = require("../../../../util/errors");
var _use_streams_app_fetch = require("../../../../hooks/use_streams_app_fetch");
var _preview_table = require("../../shared/preview_table");
var _loading_panel = require("../../../loading_panel");
var _types = require("../types");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/flyout/sample_preview_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SamplePreviewTable = props => {
  const {
    nextField,
    ...rest
  } = props;
  if ((0, _types.isSchemaFieldTyped)(nextField)) {
    return /*#__PURE__*/_react.default.createElement(SamplePreviewTableContent, (0, _extends2.default)({
      nextField: nextField
    }, rest, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 12
      }
    }));
  } else {
    return null;
  }
};
exports.SamplePreviewTable = SamplePreviewTable;
const SAMPLE_DOCUMENTS_TO_SHOW = 20;
const SamplePreviewTableContent = ({
  stream,
  nextField,
  onValidate
}) => {
  var _value$documentsWithR2;
  const {
    streamsRepositoryClient
  } = (0, _use_kibana.useKibana)().dependencies.start.streams;
  const {
    value,
    loading,
    error
  } = (0, _use_streams_app_fetch.useStreamsAppFetch)(({
    signal
  }) => {
    return streamsRepositoryClient.fetch('POST /internal/streams/{name}/schema/fields_simulation', {
      signal,
      params: {
        path: {
          name: stream.name
        },
        body: {
          field_definitions: [{
            ...(0, _utils.convertToFieldDefinitionConfig)(nextField),
            name: nextField.name
          }]
        }
      }
    });
  }, [stream.name, nextField, streamsRepositoryClient], {
    disableToastOnError: true
  });
  (0, _react.useEffect)(() => {
    if (onValidate) {
      var _value$documentsWithR;
      onValidate({
        isValid: (value === null || value === void 0 ? void 0 : value.status) === 'failure' || error ? false : true,
        isIgnored: value !== null && value !== void 0 && value.documentsWithRuntimeFieldsApplied && value !== null && value !== void 0 && (_value$documentsWithR = value.documentsWithRuntimeFieldsApplied) !== null && _value$documentsWithR !== void 0 && _value$documentsWithR.some(doc => {
          var _doc$ignored_fields;
          return (doc === null || doc === void 0 ? void 0 : doc.ignored_fields) && ((_doc$ignored_fields = doc.ignored_fields) === null || _doc$ignored_fields === void 0 ? void 0 : _doc$ignored_fields.length) > 0;
        }) ? true : false
      });
    }
  }, [value, error, onValidate]);
  const columns = (0, _react.useMemo)(() => {
    return [nextField.name];
  }, [nextField.name]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 12
      }
    });
  }
  if (value && (value.status === 'unknown' || ((_value$documentsWithR2 = value.documentsWithRuntimeFieldsApplied) === null || _value$documentsWithR2 === void 0 ? void 0 : _value$documentsWithR2.length) === 0)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      color: "warning",
      iconType: "warning",
      title: _i18n.i18n.translate('xpack.streams.samplePreviewTable.unknownStatus', {
        defaultMessage: "Couldn't simulate changes due to a lack of indexed documents with this field"
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    });
  }
  if (value && value.status === 'failure' || error) {
    var _value$simulationErro;
    const formattedError = error && (0, _errors.getFormattedError)(error);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      title: _i18n.i18n.translate('xpack.streams.samplePreviewTable.errorTitle', {
        defaultMessage: 'There was an error simulating these mapping changes with a sample of documents'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 7
      }
    }, (_value$simulationErro = value === null || value === void 0 ? void 0 : value.simulationError) !== null && _value$simulationErro !== void 0 ? _value$simulationErro : formattedError === null || formattedError === void 0 ? void 0 : formattedError.message);
  }
  if (value && value.status === 'success' && value.documentsWithRuntimeFieldsApplied) {
    return /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
          height: 500px;
        `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_preview_table.PreviewTable, {
      documents: value.documentsWithRuntimeFieldsApplied.slice(0, SAMPLE_DOCUMENTS_TO_SHOW),
      renderCellValue: (doc, columnId, ignoredFields = []) => {
        const emptyCell = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0");
        const docValue = doc[columnId];
        let renderedValue = emptyCell;
        if (typeof docValue === 'object') {
          renderedValue = JSON.stringify(docValue);
        } else {
          renderedValue = String(docValue) || emptyCell;
        }
        const isFieldIgnored = ignoredFields.find(field => (field === null || field === void 0 ? void 0 : field.field) === columnId);
        if (isFieldIgnored) {
          renderedValue = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            alignItems: "center",
            gutterSize: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 150,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
            position: "bottom",
            content: _i18n.i18n.translate('xpack.streams.samplePreviewTable.ignoredField', {
              defaultMessage: 'This value caused an issue and was ignored'
            }),
            type: "warning",
            iconProps: {
              color: 'warning'
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 151,
              columnNumber: 19
            }
          }), renderedValue);
        }
        return renderedValue;
      },
      displayColumns: columns,
      showLeadingControlColumns: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 9
      }
    }));
  }
  return null;
};