"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTypeSelector = exports.FieldFormType = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _ecs_recommendation = require("./ecs_recommendation");
var _field_type = require("../field_type");
var _use_kibana = require("../../../../hooks/use_kibana");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/flyout/field_form_type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldFormType = ({
  field,
  isEditing,
  onTypeChange
}) => {
  var _fieldsMetadata$ecsFi;
  const {
    useFieldsMetadata
  } = (0, _use_kibana.useKibana)().dependencies.start.fieldsMetadata;
  const ecsFieldName = (0, _streamsSchema.getRegularEcsField)(field.name);
  const {
    fieldsMetadata,
    loading
  } = useFieldsMetadata({
    attributes: ['type'],
    fieldNames: [ecsFieldName]
  }, [field]);

  // Propagate recommendation to state if a type is not already set
  const recommendation = fieldsMetadata === null || fieldsMetadata === void 0 ? void 0 : (_fieldsMetadata$ecsFi = fieldsMetadata[ecsFieldName]) === null || _fieldsMetadata$ecsFi === void 0 ? void 0 : _fieldsMetadata$ecsFi.type;
  (0, _react.useEffect)(() => {
    if (!loading && recommendation !== undefined &&
    // Supported type
    recommendation in _constants.FIELD_TYPE_MAP && !field.type) {
      onTypeChange(recommendation);
    }
  }, [field, loading, recommendation, onTypeChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, isEditing ? /*#__PURE__*/_react.default.createElement(FieldTypeSelector, {
    value: field.type,
    onChange: onTypeChange,
    isLoading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }) : field.type ? /*#__PURE__*/_react.default.createElement(_field_type.FieldType, {
    type: field.type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }) : _constants.EMPTY_CONTENT), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_ecs_recommendation.EcsRecommendation, {
    isLoading: loading,
    recommendation: recommendation,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  })));
};
exports.FieldFormType = FieldFormType;
const typeSelectorOptions = Object.keys(_constants.FIELD_TYPE_MAP).filter(optionKey => !_constants.FIELD_TYPE_MAP[optionKey].readonly).map(optionKey => ({
  value: optionKey,
  inputDisplay: /*#__PURE__*/_react.default.createElement(_field_type.FieldType, {
    type: optionKey,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 19
    }
  }),
  'data-test-subj': `option-type-${optionKey}`
}));
const FieldTypeSelector = ({
  value,
  onChange,
  isLoading = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    isLoading: isLoading,
    "data-test-subj": "streamsAppFieldFormTypeSelect",
    onChange: onChange,
    valueOfSelected: value,
    options: typeSelectorOptions,
    fullWidth: true,
    "aria-label": _i18n.i18n.translate('xpack.streams.fieldFormType.typeSelectAriaLabel', {
      defaultMessage: 'Field type'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  });
};
exports.FieldTypeSelector = FieldTypeSelector;