"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorListButton = ConnectorListButton;
exports.ConnectorListButtonBase = ConnectorListButtonBase;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _react = _interopRequireDefault(require("react"));
var _use_ai_features = require("../../hooks/use_ai_features");
var _enable_ai_features_link = require("../enable_ai_features_link/enable_ai_features_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/connector_list_button/connector_list_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SHOW_MORE_ARIA_LABEL = _i18n.i18n.translate('xpack.streams.connectorListButton.showMoreButtonLabel', {
  defaultMessage: 'More'
});
function ConnectorListButtonBase({
  buttonProps,
  aiFeatures
}) {
  var _buttonProps$size, _buttonProps$fill, _connectorsResult$con;
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const splitButtonPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'splitButtonPopover'
  });
  const buttonSize = (_buttonProps$size = buttonProps.size) !== null && _buttonProps$size !== void 0 ? _buttonProps$size : 's';
  const fill = (_buttonProps$fill = buttonProps.fill) !== null && _buttonProps$fill !== void 0 ? _buttonProps$fill : false;
  if (aiFeatures === null) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: buttonSize,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 12
      }
    });
  }
  if (!aiFeatures.enabled) {
    if (aiFeatures.couldBeEnabled) {
      return /*#__PURE__*/_react.default.createElement(_enable_ai_features_link.EnableAIFeaturesLink, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 14
        }
      });
    }
    return null;
  }
  const connectorsResult = aiFeatures.genAiConnectors;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    isDisabled: !(connectorsResult !== null && connectorsResult !== void 0 && (_connectorsResult$con = connectorsResult.connectors) !== null && _connectorsResult$con !== void 0 && _connectorsResult$con.length),
    isLoading: connectorsResult === null || connectorsResult === void 0 ? void 0 : connectorsResult.loading,
    size: buttonSize,
    fill: fill
  }, buttonProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }))), (connectorsResult === null || connectorsResult === void 0 ? void 0 : connectorsResult.connectors) && connectorsResult.connectors.length >= 2 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: splitButtonPopoverId,
    isOpen: isPopoverOpen,
    closePopover: () => closePopover(),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "streamsAppAiPickConnectorButton",
      onClick: togglePopover,
      display: "base",
      size: buttonSize,
      iconType: "boxesVertical",
      "aria-label": SHOW_MORE_ARIA_LABEL,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 15
      }
    }),
    panelPaddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: connectorsResult.connectors.map(connector => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: connector.id,
      icon: connector.id === connectorsResult.selectedConnector ? 'check' : 'empty',
      onClick: () => {
        connectorsResult.selectConnector(connector.id);
        closePopover();
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 17
      }
    }, connector.name)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }))));
}
function ConnectorListButton({
  buttonProps
}) {
  const aiFeatures = (0, _use_ai_features.useAIFeatures)();
  return /*#__PURE__*/_react.default.createElement(ConnectorListButtonBase, {
    buttonProps: buttonProps,
    aiFeatures: aiFeatures,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 10
    }
  });
}