module.exports = "Your task is to partition a single data stream into logical partitions. The single data stream may contain multiple partitions. Each partition MUST represent a single system.\n\n**System definition**:\n\nA \"System\" is a _single, specific_ software component, application, or service. Grouping multiple distinct systems (e.g., all databases) into one partition is incorrect. Think of it as the most granular source you want to isolate.\n\nSome examples:\n  - Specific infrastructure services: A load balancer (e.g., `lb-edge`), a stream processing unit (e.g., `stream-processor-alpha`), a central authentication service (e.g., `authn-core`), a distributed cache (`dist-cache-main`), a message broker (`msg-broker-prod`), a web server (`web-frontend-pool`), an application server (`app-server-backend`).\n  - Specific application logs:\n    - `order-processing-svc` (a microservice, treated as one system).\n    - `inventory-update-worker` (a background job, treated as another distinct system).\n    - `legacy-reporting-system` (a monolithic application, treated as one system).\n  - Specific os/host log types (if distinguishable and needing separation): Potentially `kernel-logs-compute-node-123`, `auth-events-fileserver-abc` if they have distinct, consistent characteristics and represent different informational streams. Often, a field like `host.id` or `system.source_type` will help distinguish these.\n  - Specific Cloud Service Logs: `cloud-provider-trails` (as one system), `blob-storage-access-events` (as another, distinct system if its logs are different), `serverless-function-invocations`.\n  - Specific Network Device Logs: `firewall-dmz-primary` (as one system), `vpn-gateway-regional` (as another).\n  - Specific Databases: `document-store-prod` (for its general logs, as one system), `timeseries-db-metrics` (for its logs, as another). If you had two different instances of the same database type (e.g., two separate `analytics-db` instances) with vastly different log structures or purposes that are identifiable, they _could_ even be separate systems.\n\n/***************************************************************\n*\n*   For the prompt generating LLM:\n*   \n*   Include examples of how _not_ to partition (including in the\n*   reasoning examples). E.g., too wide partitioning based on\n*   initial clustering hints that are too coarse, or vice versa.\n*   Emphasize that clustering is a hint.\n*\n***************************************************************/\n\nThese should all fall into a SINGLE partition PER unique system. Do not group distinct systems together in a single partition.\n\n**The guiding principle is: if two data sources have different schemas or represent fundamentally different operational concerns, they are different Systems and need their own Partitions.** Even if initial clustering groups them due to some schema similarities, your deeper analysis should aim to separate them if they are indeed distinct systems.\n\nYou have access to a `partition_logs(index=string, partitions=Partition[])` tool. The current partitioning and the clusters within each partition will be included in the system prompt. It allows you to test your partitioning. Partinioning works as follows:\n\n- Each partition has a `name`. the name should be alphanumerical chars + dashes. No underscores or dots. `name` will be appended to its parent (`index`), e.g. `redis-prod` will become `logs.redis-prod`.\n- Each partition has a `condition` under which the document gets routed to its defined target.\n- They are executed top-to-bottom, which means that the document will get routed to the first partition where the condition matches.\n- The schema for `condition` is referenced below as `condition_schema`.\n\nWhen calling `partition_logs`, you need to define the complete set of suggested partitions you want to add and validate. It will cluster logs based on DBScan and Jaccard similarity, **for each suggested partition**, **and the documents that do not match any partition and fall through**. The clustering in a partition give you a *hint* that the documents might need to be partitioned further. Ideally every document falls into a logical partition. If needed, keep adding partitions until all documents have been partitioned and there is a low amount of per-partition clusters. The count in each cluster is based on sampled documents - look at them relatively instead of absolutely.\n\nAfter calling `complete`, you MUST finalize the process by call the `cluster_logs` tool once more with the finalized partitions.\n\n/***************************************************************\n*\n*   For the prompt generating LLM:\n*   \n*   Reference the schema below using `{{{condition_schema}}}` in\n*   a section at the end called \"System variables\".\n*   Mustache will be used to render it into the system prompt.\n*\n***************************************************************/\n\n`condition_schema`:\n```json\n{{{condition_schema}}}\n```\n";
