"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestStreamPartitionsPrompt = void 0;
var _zod = require("@kbn/zod");
var _inferenceCommon = require("@kbn/inference-common");
var _streamsSchema = require("@kbn/streams-schema");
var _system_prompt = _interopRequireDefault(require("./system_prompt.text"));
var _content_prompt = _interopRequireDefault(require("./content_prompt.text"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SuggestStreamPartitionsPrompt = exports.SuggestStreamPartitionsPrompt = (0, _inferenceCommon.createPrompt)({
  name: 'suggest_stream_partitions_prompt',
  description: 'Suggest stream partitions based on sample data',
  input: _zod.z.object({
    stream: _streamsSchema.Streams.all.Definition.right,
    condition_schema: _zod.z.string(),
    initial_clustering: _zod.z.string()
  })
}).version({
  system: {
    mustache: {
      template: _system_prompt.default
    }
  },
  template: {
    mustache: {
      template: _content_prompt.default
    }
  },
  tools: {
    partition_logs: {
      description: `Simulates the partioning conditions specified, and clusters documents within each partition.`,
      schema: {
        type: 'object',
        properties: {
          index: {
            type: 'string'
          },
          partitions: {
            type: 'array',
            items: {
              type: 'object',
              properties: {
                name: {
                  type: 'string'
                },
                condition: {
                  type: 'object',
                  properties: {}
                }
              },
              required: ['name', 'condition']
            }
          }
        },
        required: ['index']
      }
    }
  }
}).get();