"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParamsSchema = exports.HeadersSchema = exports.ConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _schema = require("../../../common/auth/schema");
var _constants = require("../../../common/auth/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeadersSchema = exports.HeadersSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string());
const configSchemaProps = {
  url: _configSchema.schema.string(),
  method: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.WebhookMethods.POST), _configSchema.schema.literal(_constants.WebhookMethods.PUT), _configSchema.schema.literal(_constants.WebhookMethods.PATCH), _configSchema.schema.literal(_constants.WebhookMethods.GET), _configSchema.schema.literal(_constants.WebhookMethods.DELETE)], {
    defaultValue: _constants.WebhookMethods.POST
  }),
  headers: _configSchema.schema.nullable(HeadersSchema),
  hasAuth: _schema.AuthConfiguration.hasAuth,
  authType: _schema.AuthConfiguration.authType,
  certType: _schema.AuthConfiguration.certType,
  ca: _schema.AuthConfiguration.ca,
  verificationMode: _schema.AuthConfiguration.verificationMode,
  accessTokenUrl: _schema.AuthConfiguration.accessTokenUrl,
  clientId: _schema.AuthConfiguration.clientId,
  scope: _schema.AuthConfiguration.scope,
  additionalFields: _schema.AuthConfiguration.additionalFields
};
const ConfigSchema = exports.ConfigSchema = _configSchema.schema.object(configSchemaProps);

// params definition
const ParamsSchema = exports.ParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.maybe(_configSchema.schema.string())
});