"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getResilientConnectorType = void 0;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _schema = require("./schema");
var _resilient = require("./resilient");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getResilientConnectorType = () => ({
  id: _constants.RESILIENT_CONNECTOR_ID,
  minimumLicenseRequired: 'platinum',
  name: i18n.NAME,
  getService: params => new _resilient.ResilientConnector(params, _schema.PushToServiceIncidentSchema),
  schema: {
    config: _schema.ExternalIncidentServiceConfigurationSchema,
    secrets: _schema.ExternalIncidentServiceSecretConfigurationSchema
  },
  supportedFeatureIds: [_common.AlertingConnectorFeatureId, _common.CasesConnectorFeatureId, _common.SecurityConnectorFeatureId],
  validators: [{
    type: _types.ValidatorType.CONFIG,
    validator: (0, _server.urlAllowListValidator)('apiUrl')
  }]
});
exports.getResilientConnectorType = getResilientConnectorType;