"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initDashboard = void 0;
var _gen_ai_dashboard = require("./gen_ai_dashboard");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initDashboard = async ({
  logger,
  savedObjectsClient,
  dashboardId,
  genAIProvider
}) => {
  try {
    await savedObjectsClient.get('dashboard', dashboardId);
    return {
      success: true
    };
  } catch (error) {
    // if 404, does not yet exist. do not error, continue to create
    if (error.output.statusCode !== 404) {
      return {
        success: false,
        error: {
          message: `${error.output.payload.error}${error.output.payload.message ? `: ${error.output.payload.message}` : ''}`,
          statusCode: error.output.statusCode
        }
      };
    }
  }
  try {
    await savedObjectsClient.create('dashboard', (0, _gen_ai_dashboard.getDashboard)(genAIProvider, dashboardId).attributes, {
      overwrite: true,
      id: dashboardId
    });
    logger.info(`Successfully created Generative AI Dashboard ${dashboardId}`);
    return {
      success: true
    };
  } catch (error) {
    return {
      success: false,
      error: {
        message: error.message,
        statusCode: error.output.statusCode
      }
    };
  }
};
exports.initDashboard = initDashboard;