"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _steps = require("./steps");
var _use_get_application = require("./use_get_application");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/swimlane/swimlane_connectors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SwimlaneActionConnectorFields = ({
  readOnly
}) => {
  var _config$apiUrl, _config$appId, _secrets$apiToken;
  const {
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const [hasConfigurationErrors, setHasConfigurationError] = (0, _react.useState)(false);
  const {
    isValid,
    validateFields
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    config,
    secrets
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.apiUrl', 'config.appId', 'secrets.apiToken']
  });
  const {
    getApplication,
    isLoading: isLoadingApplication
  } = (0, _use_get_application.useGetApplication)({
    toastNotifications: toasts
  });
  const apiUrl = (_config$apiUrl = config === null || config === void 0 ? void 0 : config.apiUrl) !== null && _config$apiUrl !== void 0 ? _config$apiUrl : '';
  const appId = (_config$appId = config === null || config === void 0 ? void 0 : config.appId) !== null && _config$appId !== void 0 ? _config$appId : '';
  const apiToken = (_secrets$apiToken = secrets === null || secrets === void 0 ? void 0 : secrets.apiToken) !== null && _secrets$apiToken !== void 0 ? _secrets$apiToken : '';
  const [currentStep, setCurrentStep] = (0, _react.useState)(1);
  const [fields, setFields] = (0, _react.useState)([]);
  const updateCurrentStep = (0, _react.useCallback)(step => {
    setCurrentStep(step);
  }, []);
  const onNextStep = (0, _react.useCallback)(async () => {
    setHasConfigurationError(false);
    const {
      areFieldsValid
    } = await validateFields(['config.apiUrl', 'config.appId', 'secrets.apiToken']);
    if (!areFieldsValid) {
      setHasConfigurationError(true);
      return;
    }

    // fetch swimlane application configuration
    const application = await getApplication({
      apiUrl,
      appId,
      apiToken
    });
    if (application !== null && application !== void 0 && application.fields) {
      const allFields = application.fields;
      setFields(allFields);
      setCurrentStep(2);
    }
  }, [apiToken, apiUrl, appId, getApplication, validateFields]);
  const resetConnection = (0, _react.useCallback)(() => {
    setCurrentStep(1);
  }, []);
  const steps = (0, _react.useMemo)(() => [{
    title: i18n.SW_CONFIGURE_CONNECTION_LABEL,
    isSelected: currentStep === 1,
    status: currentStep === 1 ? 'selected' : currentStep === 2 ? 'complete' : 'incomplete',
    onClick: () => updateCurrentStep(1)
  }, {
    title: i18n.SW_MAPPING_TITLE_TEXT_FIELD_LABEL,
    disabled: hasConfigurationErrors || isLoadingApplication,
    onClick: onNextStep,
    status: !isValid ? 'danger' : currentStep === 2 ? 'selected' : 'incomplete'
  }], [currentStep, hasConfigurationErrors, isLoadingApplication, isValid, onNextStep, updateCurrentStep]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: currentStep === 1 ? 'block' : 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_steps.SwimlaneConnection, {
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: i18n.SW_FIELDS_BUTTON_HELP_TEXT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton
  // disabled={hasConfigurationErrors || isLoadingApplication}
  , {
    isLoading: isLoadingApplication,
    onClick: onNextStep,
    "data-test-subj": "swimlaneConfigureMapping",
    iconType: "arrowRight",
    iconSide: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }, i18n.SW_NEXT))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: currentStep === 2 ? 'block' : 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_steps.SwimlaneFields, {
    fields: fields,
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: resetConnection,
    iconType: "arrowLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, i18n.SW_BACK))));
};

// eslint-disable-next-line import/no-default-export
exports.default = SwimlaneActionConnectorFields;
module.exports = exports.default;