"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OAuth = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/lib/servicenow/auth_types/oauth.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;
const OAuthComponent = ({
  isLoading,
  readOnly,
  pathPrefix = ''
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${pathPrefix}config.clientId`,
    component: _components.TextField,
    config: {
      label: i18n.CLIENTID_LABEL,
      validations: [{
        validator: emptyField(i18n.CLIENTID_REQUIRED)
      }]
    },
    componentProps: {
      id: 'clientId',
      euiFieldProps: {
        'data-test-subj': 'connector-servicenow-client-id-form-input',
        readOnly,
        isLoading,
        disabled: readOnly || isLoading
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${pathPrefix}config.userIdentifierValue`,
    component: _components.TextField,
    config: {
      label: i18n.USER_IDENTIFIER_LABEL,
      validations: [{
        validator: emptyField(i18n.USER_IDENTIFIER_REQUIRED)
      }]
    },
    componentProps: {
      id: 'userIdentifierValue',
      euiFieldProps: {
        'data-test-subj': 'connector-servicenow-user-identifier-form-input',
        readOnly,
        disabled: readOnly || isLoading,
        isLoading
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${pathPrefix}config.jwtKeyId`,
    component: _components.TextField,
    config: {
      label: i18n.KEY_ID_LABEL,
      validations: [{
        validator: emptyField(i18n.KEYID_REQUIRED)
      }]
    },
    componentProps: {
      id: 'jwtKeyId',
      euiFieldProps: {
        'data-test-subj': 'connector-servicenow-jwt-key-id-form-input',
        readOnly,
        disabled: readOnly || isLoading,
        isLoading
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${pathPrefix}secrets.clientSecret`,
    config: {
      label: i18n.CLIENTSECRET_LABEL,
      validations: [{
        validator: emptyField(i18n.CLIENTSECRET_REQUIRED)
      }]
    },
    component: _components.PasswordField,
    componentProps: {
      id: 'clientSecret',
      euiFieldProps: {
        'data-test-subj': 'connector-servicenow-client-secret-form-input',
        isLoading,
        readOnly,
        disabled: readOnly || isLoading
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.privateKey",
    component: _components.TextAreaField,
    config: {
      label: i18n.PRIVATE_KEY_LABEL,
      validations: [{
        validator: emptyField(i18n.PRIVATE_KEY_REQUIRED)
      }]
    },
    componentProps: {
      id: 'privateKey',
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'connector-servicenow-private-key-form-input',
        disabled: readOnly || isLoading
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${pathPrefix}secrets.privateKeyPassword`,
    config: {
      label: i18n.PRIVATE_KEY_PASSWORD_LABEL,
      validations: [],
      helpText: i18n.PRIVATE_KEY_PASSWORD_HELPER_TEXT
    },
    component: _components.PasswordField,
    componentProps: {
      id: 'privateKeyPassword',
      euiFieldProps: {
        'data-test-subj': 'connector-servicenow-private-key-password-form-input',
        isLoading,
        readOnly,
        disabled: readOnly || isLoading
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }));
};
const OAuth = exports.OAuth = /*#__PURE__*/(0, _react.memo)(OAuthComponent);